/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.SimpleContentFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.expr.EmptyTextNodeRemover;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public class EmptyTextNodeRemoverAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) {
        EmptyTextNodeRemover scc = (EmptyTextNodeRemover)this.getExpression();
        if (Streamability.getSweep(scc) == Sweep.CONSUMING) {
            Expression select = scc.getBaseExpression();
            final Pattern selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null);
            if (selection != null) {
                return new WatchMaker(){

                    @Override
                    public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) {
                        SimpleContentFeed action = new SimpleContentFeed(out);
                        Trigger watch = new Trigger(selection, action, context);
                        watch.setPipelineConfiguration(watchManager.getPipelineConfiguration());
                        return watch;
                    }
                };
            }
            return null;
        }
        return null;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new ItemFeed(this.getExpression(), out, context){

            @Override
            public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
                return this.getResult().startSelectedParentNode(node, locationId);
            }

            @Override
            public void endSelectedParentNode(Location locationId) throws XPathException {
                this.getResult().endSelectedParentNode(locationId);
            }

            @Override
            public void processItem(Item<?> item) throws XPathException {
                if (!AdjacentTextNodeMerger.isTextNode(item) || item.getStringValueCS().length() != 0) {
                    this.getResult().processItem(item);
                }
            }
        };
    }
}

