/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class NewMapStreamer
extends StreamingAdjunct
implements FeedMaker {
    private Inversion[] actionInversions;

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
        Expression block = exp.getArg(0);
        if (!(block instanceof Block)) {
            return super.computeStreamability(contextInfo, reasons);
        }
        Operand[] children = ((Block)block).getOperanda();
        if (children.length == 0) {
            return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        }
        Sweep sweep = Sweep.MOTIONLESS;
        for (Operand o : children) {
            Expression e = o.getChildExpression();
            if (!e.isCallOn(MapFunctionSet.MapEntry.class)) {
                return super.computeStreamability(contextInfo, reasons);
            }
            PostureAndSweep ps = Streamability.getStreamability(e, contextInfo, reasons);
            if (ps.getPosture() == Posture.ROAMING || ps.getSweep() == Sweep.FREE_RANGING) {
                Streamability.setPostureAndSweep(block, PostureAndSweep.ROAMING_AND_FREE_RANGING);
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            sweep = Sweep.wider(sweep, ps.getSweep());
        }
        PostureAndSweep ps = new PostureAndSweep(Posture.GROUNDED, sweep);
        Streamability.setPostureAndSweep(block, ps);
        return ps;
    }

    private Operand[] getChildren() {
        SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
        Expression arg = exp.getArg(0);
        return ((Block)arg).getOperanda();
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
        Expression block = exp.getArg(0);
        if (!(block instanceof Block)) {
            return super.getWatchMaker(forGrouping);
        }
        Operand[] actions = this.getChildren();
        if (this.actionInversions == null) {
            this.actionInversions = new Inversion[actions.length];
            for (int i = 0; i < actions.length; ++i) {
                Expression action = actions[i].getChildExpression();
                this.actionInversions[i] = Streamability.getSweep(action) == Sweep.CONSUMING ? Inversion.invertExpression(action, forGrouping) : null;
            }
        }
        return (watchManager, out, context) -> new Trigger(AnchorPattern.getInstance(), new NewMapForkingFeed(this.getExpression(), out, context, watchManager), context);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new NewMapSimpleFeed(this.getExpression(), out, context);
    }

    private class NewMapSimpleFeed
    extends ItemFeed {
        HashTrieMap resultMap;

        public NewMapSimpleFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.resultMap = new HashTrieMap();
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (item instanceof MapItem) {
                for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                    boolean existing = this.resultMap.initialPut(pair.key, pair.value);
                    if (!existing) continue;
                    XPathException err = new XPathException("Duplicate key value in map: " + Err.depict(pair.key), "XTDE3365");
                    this.dynamicError(err);
                }
            } else {
                XPathException err = new XPathException("Argument to map constructor contains an item that is not a map", "XPTY0004");
                err.setIsTypeError(true);
                this.dynamicError(err);
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                Feed out = this.getResult();
                out.processItem(this.resultMap);
                out.close();
            }
            this.resultMap = null;
        }
    }

    private class NewMapForkingFeed
    extends ItemFeed {
        WatchManager watchManager;
        HashTrieMap resultMap;

        public NewMapForkingFeed(Expression exp, Feed result, XPathContext context, WatchManager watchManager) {
            super(exp, result, context);
            this.watchManager = watchManager;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.resultMap = new HashTrieMap();
            Operand[] actions = NewMapStreamer.this.getChildren();
            for (int i = 0; i < actions.length; ++i) {
                Expression action = actions[i].getChildExpression();
                if (Streamability.getSweep(action) == Sweep.CONSUMING) {
                    ItemFeed feed = new ItemFeed(this.getResult(), this.getContext()){

                        @Override
                        public void open(Terminator terminator) {
                        }

                        @Override
                        public void processItem(Item<?> item) throws XPathException {
                            for (KeyValuePair pair : ((MapItem)item).keyValuePairs()) {
                                if (NewMapForkingFeed.this.resultMap.get(pair.key) != null) {
                                    XPathException err = new XPathException("Duplicate key value in map: " + Err.depict(pair.key), "XTDE3365");
                                    this.dynamicError(err);
                                    continue;
                                }
                                NewMapForkingFeed.this.resultMap = NewMapForkingFeed.this.resultMap.addEntry(pair.key, (GroundedValue)pair.value);
                            }
                        }

                        @Override
                        public void close() {
                        }

                        @Override
                        public void setHasFailed() {
                            NewMapForkingFeed.this.setHasFailed();
                        }
                    };
                    if (Streamability.getPosture(action) != Posture.GROUNDED) {
                        feed = new CopyOfFeed(this.watchManager, (Feed)feed, this.getContext());
                    }
                    this.watchManager.addWatch(NewMapStreamer.this.actionInversions[i].getWatch(this.watchManager, feed, this.getContext()), true);
                    continue;
                }
                MapItem sm = (MapItem)action.evaluateItem(this.getContext());
                for (KeyValuePair pair : sm.keyValuePairs()) {
                    if (this.resultMap.get(pair.key) != null) {
                        XPathException err = new XPathException("Duplicate key value in map: " + Err.depict(pair.key), "XTDE3365");
                        this.dynamicError(err);
                        continue;
                    }
                    this.resultMap = this.resultMap.addEntry(pair.key, (GroundedValue)pair.value);
                }
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return null;
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                Feed out = this.getResult();
                out.processItem(this.resultMap);
                out.close();
            }
            this.resultMap = null;
        }
    }
}

