/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.SlashExpressionCompiler;
import com.saxonica.ee.bytecode.SortExpressionCompiler;
import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.map.CompiledContextMappingFunction;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GroupAdjacentIterator;
import net.sf.saxon.expr.sort.GroupByIterator;
import net.sf.saxon.expr.sort.GroupEndingIterator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupStartingIterator;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedGroupIterator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.type.TypeHierarchy;

public class ForEachGroupCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ForEachGroup instr = (ForEachGroup)expression;
        ForEachGroupCompiler.visitAnnotation(compiler, "ForEachGroupCompiler-Push");
        ForEachGroupCompiler.visitLineNumber(compiler, ga, expression);
        this.getGroupIterator(compiler, expression);
        int groupIterVar = methodInfo.allocateLocal(GroupIterator.class);
        ga.storeLocal(groupIterVar);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        int context2Var = methodInfo.allocateLocal(XPathContextMajor.class);
        ga.storeLocal(context2Var);
        methodInfo.pushContextVariableInfo(context2Var, false);
        ga.loadLocal(context2Var);
        ga.loadLocal(groupIterVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentGroupIterator", GroupIterator.class);
        ga.loadLocal(context2Var);
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        ga.loadLocal(groupIterVar);
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        ga.loadLocal(context2Var);
        ga.pushNull();
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentTemplateRule", Rule.class);
        LabelInfo loop = methodInfo.placeNewLabel("groupLoop");
        LabelInfo groupBreak = methodInfo.newLabel("groupBreak");
        ga.loadLocal(context2Var);
        ga.invokeInstanceMethod(XPathContext.class, "getCurrentIterator", new Class[0]);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.ifNull(groupBreak.label());
        compiler.compileToPush(instr.getActionExpression());
        ga.goTo(loop);
        methodInfo.placeLabel(groupBreak);
        methodInfo.popContextVariableInfo();
        methodInfo.releaseLocal(context2Var);
        methodInfo.releaseLocal(groupIterVar);
    }

    private void getGroupIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ForEachGroupCompiler.visitLineNumber(compiler, ga, expression);
        ForEachGroup instr = (ForEachGroup)expression;
        switch (instr.getAlgorithm()) {
            case 0: {
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "newMinorContext", new Class[0]);
                int context2Var = methodInfo.allocateLocal(XPathContext.class);
                int populationVar = methodInfo.allocateLocal(SequenceIterator.class);
                ga.newInstance(FocusTrackingIterator.class);
                ga.dup();
                compiler.compileToIterator(instr.getSelectExpression());
                ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
                ga.checkClass(SequenceIterator.class);
                ga.storeLocal(populationVar);
                ga.storeLocal(context2Var);
                ga.loadLocal(context2Var);
                ga.loadLocal(populationVar);
                ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
                ga.newInstance(GroupByIterator.class);
                ga.dup();
                ga.loadLocal(populationVar);
                ForEachGroupCompiler.allocateStatic(compiler, instr.getGroupingKey());
                ga.loadLocal(context2Var);
                if (instr.getCollation() == null) {
                    this.getStringCollator(compiler, instr);
                } else {
                    ForEachGroupCompiler.allocateStatic(compiler, instr.getCollation());
                }
                ga.push(instr.isComposite());
                ga.invokeConstructor(GroupByIterator.class, SequenceIterator.class, Expression.class, XPathContext.class, StringCollator.class, Boolean.TYPE);
                methodInfo.releaseLocal(context2Var);
                methodInfo.releaseLocal(populationVar);
                break;
            }
            case 1: {
                ga.newInstance(GroupAdjacentIterator.class);
                ga.dup();
                ForEachGroupCompiler.allocateStatic(compiler, instr.getSelectExpression());
                ForEachGroupCompiler.allocateStatic(compiler, instr.getGroupingKey());
                compiler.generateGetContext();
                if (instr.getCollation() == null) {
                    this.getStringCollator(compiler, instr);
                } else {
                    ForEachGroupCompiler.allocateStatic(compiler, instr.getCollation());
                }
                ga.push(instr.isComposite());
                ga.invokeConstructor(GroupAdjacentIterator.class, Expression.class, Expression.class, XPathContext.class, StringCollator.class, Boolean.TYPE);
                break;
            }
            case 2: {
                ga.newInstance(GroupStartingIterator.class);
                ga.dup();
                ForEachGroupCompiler.allocateStatic(compiler, instr.getSelectExpression());
                ForEachGroupCompiler.allocateStatic(compiler, instr.getGroupingKey());
                compiler.generateGetContext();
                ga.invokeConstructor(GroupStartingIterator.class, Expression.class, Pattern.class, XPathContext.class);
                break;
            }
            case 3: {
                ga.newInstance(GroupEndingIterator.class);
                ga.dup();
                ForEachGroupCompiler.allocateStatic(compiler, instr.getSelectExpression());
                ForEachGroupCompiler.allocateStatic(compiler, instr.getGroupingKey());
                compiler.generateGetContext();
                ga.invokeConstructor(GroupEndingIterator.class, Expression.class, Pattern.class, XPathContext.class);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (instr.getSortKeyDefinitions() != null) {
            int gpIterVar = methodInfo.allocateLocal(GroupByIterator.class);
            ga.storeLocal(gpIterVar);
            ga.newInstance(SortedGroupIterator.class);
            ga.dup();
            compiler.generateGetContext();
            ga.loadLocal(gpIterVar);
            ForEachGroupCompiler.allocateStatic(compiler, instr);
            if (instr.getSortKeyComparators() == null) {
                int skdVar = SortExpressionCompiler.compileSortKeyDefinitions(compiler, instr.getSortKeyDefinitions());
                ga.loadLocal(skdVar);
            } else {
                ForEachGroupCompiler.allocateStatic(compiler, instr.getSortKeyComparators());
            }
            AtomicComparer[] comp1 = instr.getSortKeyComparators();
            ga.invokeConstructor(SortedGroupIterator.class, XPathContext.class, GroupIterator.class, SortKeyEvaluator.class, AtomicComparer[].class);
            methodInfo.releaseLocal(gpIterVar);
        }
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ForEachGroup instr = (ForEachGroup)expression;
        ForEachGroupCompiler.visitAnnotation(compiler, "ForEachGroupCompiler-Itr");
        ForEachGroupCompiler.visitLineNumber(compiler, ga, expression);
        CompiledContextMappingFunction contextMapFunc = SlashExpressionCompiler.generateMappingFunction(compiler, instr.getActionExpression());
        this.getGroupIterator(compiler, expression);
        int groupIterVar = methodInfo.allocateLocal(GroupIterator.class);
        ga.storeLocal(groupIterVar);
        ga.newInstance(ContextMappingIterator.class);
        ga.dup();
        ForEachGroupCompiler.allocateStatic(compiler, contextMapFunc);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        ga.dup();
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        ga.loadLocal(groupIterVar);
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        ga.dup();
        ga.loadLocal(groupIterVar);
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentGroupIterator", GroupIterator.class);
        ga.dup();
        ga.pushNull();
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentTemplateRule", Rule.class);
        ga.invokeConstructor(ContextMappingIterator.class, ContextMappingFunction.class, XPathContext.class);
        methodInfo.releaseLocal(groupIterVar);
    }

    private void getStringCollator(CompilerService compiler, ForEachGroup instr) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        ForEachGroupCompiler.allocateStatic(compiler, compiler.getConfiguration());
        compiler.compileToPrimitive(instr.getCollationNameExpression(), String.class, OnEmpty.RETURN_EMPTY_STRING);
        ForEachGroupCompiler.allocateStatic(compiler, instr.getBaseURI().toString());
        ga.push("FOCH0002");
        ga.invokeInstanceMethod(Configuration.class, "getCollation", String.class, String.class, String.class);
    }
}

