/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemCheckingFeed;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trans.XPathException;

public class ItemCheckerAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        ItemChecker expr = (ItemChecker)this.getExpression();
        PostureAndSweep base = Streamability.getStreamability(expr.getBaseExpression(), contextInfo, reasons);
        if (base.getPosture() != Posture.ROAMING && base.getSweep() != Sweep.FREE_RANGING && expr.getRequiredType() instanceof DocumentNodeTest) {
            reasons.add("The node-test " + expr.getRequiredType() + " requires look-ahead");
            return new PostureAndSweep(Posture.ROAMING, Sweep.FREE_RANGING);
        }
        return base;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new ItemCheckingFeed(this.getExpression(), out, context);
    }
}

