/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.InsertAction;
import com.saxonica.ee.update.InsertAttributeAction;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.validate.SkipValidator;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class InsertExpression
extends BasicUpdatingExpression {
    private int position;
    private int constructionMode;
    private boolean inheritNamespaces;
    private boolean preserveNamespaces;
    private Operand sourceOp;
    private Operand targetOp;

    public InsertExpression(Expression source, Expression target, int position, int constructionMode, boolean inherit, boolean preserve) {
        this.sourceOp = new Operand(this, source, OperandRole.SINGLE_ATOMIC);
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.position = position;
        this.constructionMode = constructionMode;
        this.inheritNamespaces = inherit;
        this.preserveNamespaces = preserve;
    }

    public Expression getSourceExpression() {
        return this.sourceOp.getChildExpression();
    }

    public void setSourceExpression(Expression sourceExpression) {
        this.sourceOp.setChildExpression(sourceExpression);
    }

    public Expression getTargetExpression() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExpression(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.sourceOp, this.targetOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        RoleDiagnostic role0 = new RoleDiagnostic(10, "insert", 1);
        role0.setErrorCode("XUDY0027");
        this.setTargetExpression(tc.staticTypeCheck(this.getTargetExpression(), SequenceType.NON_EMPTY_SEQUENCE, role0, visitor));
        role0 = new RoleDiagnostic(10, "insert", 1);
        role0.setErrorCode(this.position == 118 || this.position == 119 ? "XUTY0006" : "XUTY0005");
        this.setTargetExpression(tc.staticTypeCheck(this.getTargetExpression(), SequenceType.OPTIONAL_NODE, role0, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        InsertExpression exp = new InsertExpression(this.getSourceExpression().copy(rebindings), this.getTargetExpression().copy(rebindings), this.position, this.constructionMode, this.inheritNamespaces, this.preserveNamespaces);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public String getExpressionName() {
        return "insert";
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("insert", this);
        out.emitAttribute("position", Token.tokens[this.position]);
        out.emitAttribute("constructionMode", Validation.toString(this.constructionMode));
        this.getSourceExpression().export(out);
        this.getTargetExpression().export(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        Object item;
        NodeInfo parent;
        ArrayList content = new ArrayList();
        NodeInfo target = (NodeInfo)this.getTargetExpression().evaluateItem(context);
        if (target == null) {
            XPathException e = new XPathException("Target of insert expression must not be empty", "XUDY0027");
            e.setLocation(this.getLocation());
            e.setXPathContext(context);
            throw e;
        }
        int kind = target.getNodeKind();
        if (this.position == 118 || this.position == 119) {
            if (kind != 1 && kind != 3 && kind != 8 && kind != 7) {
                XPathException e = new XPathException("When inserting before or after a node, that node must be an element, text, comment, or processing-instruction node", "XUTY0006");
                e.setLocation(this.getLocation());
                e.setXPathContext(context);
                throw e;
            }
        } else if (kind != 1 && kind != 9) {
            XPathException e = new XPathException("When inserting into a target node, that node must be an element or document node", "XUTY0005");
            e.setLocation(this.getLocation());
            e.setXPathContext(context);
            throw e;
        }
        NodeInfo nodeInfo = parent = this.position == 118 || this.position == 119 ? target.getParent() : target;
        if (parent == null) {
            XPathException err = new XPathException("When inserting before or after a node, that node must have a parent", "XUDY0029");
            err.setLocation(this.getLocation());
            err.setXPathContext(context);
            throw err;
        }
        if (!(parent instanceof MutableNodeInfo)) {
            XPathException err = new XPathException("Target node of insert expression is not updateable", "SXUP0081");
            err.setLocation(this.getLocation());
            err.setXPathContext(context);
            throw err;
        }
        boolean foundNonAttribute = false;
        SequenceIterator<?> iter = this.getSourceExpression().iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2) {
                SimpleType attributeType;
                XPathException err;
                if (foundNonAttribute) {
                    err = new XPathException("Attributes must precede non-attributes in the list of nodes to be inserted", "XUTY0004");
                    err.setLocation(this.getLocation());
                    err.setXPathContext(context);
                    throw err;
                }
                if (parent.getNodeKind() != 1) {
                    if (this.position == 118 || this.position == 119) {
                        err = new XPathException("When inserting an attribute before or after a node, that node must have a parent and the parent must be an element", "XUDY0030");
                        err.setLocation(this.getLocation());
                        err.setXPathContext(context);
                        throw err;
                    }
                    err = new XPathException("When inserting an attribute into a target node, the target node must be an element", "XUTY0022");
                    err.setLocation(this.getLocation());
                    err.setXPathContext(context);
                    throw err;
                }
                NodeInfo copiedNode = (NodeInfo)item;
                int properties = 0;
                if (this.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                    attributeType = BuiltInAtomicType.UNTYPED_ATOMIC;
                } else {
                    attributeType = (SimpleType)copiedNode.getSchemaType();
                    if (copiedNode.isId() || "id".equals(copiedNode.getLocalPart()) && "http://www.w3.org/XML/1998/namespace".equals(copiedNode.getURI())) {
                        properties |= 0x800;
                    }
                    if (copiedNode.isIdref()) {
                        properties |= 0x1000;
                    }
                }
                try {
                    InsertAttributeAction action = new InsertAttributeAction(parent, NameOfNode.makeName(copiedNode), attributeType, copiedNode.getStringValue(), properties);
                    action.setOriginator(this);
                    ((PendingUpdateListImpl)pul).add(action);
                    continue;
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this.getLocation());
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            foundNonAttribute = true;
            content.add(item);
        }
        if (!content.isEmpty()) {
            Builder builder = ((MutableNodeInfo)parent).newBuilder();
            Controller controller = context.getController();
            builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(this.getPackageData().getHostLanguage());
            pipe.setXPathContext(context);
            builder.setPipelineConfiguration(pipe);
            Receiver r = builder;
            if (this.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                r = new SkipValidator(r);
            }
            TreeReceiver out = new TreeReceiver(r);
            out.setPipelineConfiguration(pipe);
            out.open();
            out.startDocument(0);
            int copyNs = this.preserveNamespaces ? 524288 : 0;
            for (Item n : content) {
                out.append(n, ExplicitLocation.UNKNOWN_LOCATION, copyNs);
            }
            out.endDocument();
            out.close();
            NodeInfo root = builder.getCurrentRoot();
            AxisIterator top = root.iterateAxis((byte)3);
            SequenceExtent<NodeInfo> extent = new SequenceExtent<NodeInfo>(top);
            int len = extent.getLength();
            NodeInfo[] array = new NodeInfo[len];
            for (int i = 0; i < len; ++i) {
                array[i] = extent.itemAt(i);
            }
            InsertAction action = new InsertAction(array, (MutableNodeInfo)target, this.position, this.inheritNamespaces);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        }
    }
}

