/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica;

import com.saxonica.config.EnterpriseConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.lib.StandardInvalidityHandler;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Validate {
    protected Processor processor;
    protected EnterpriseConfiguration config;
    protected boolean useURLs = false;
    protected boolean showTime = false;
    protected int repeat = 1;
    protected String validationMode = "strict";
    protected int xsdLanguageVersion = 11;
    protected String topLevelElementName = null;
    private boolean allowExit = true;

    public static void main(String[] args) throws Exception {
        Validate validate = new Validate();
        int rc = validate.doValidate(args);
        if (rc != 0 && validate.allowExit) {
            System.exit(rc);
        }
    }

    protected void setConfiguration() {
        this.config = new EnterpriseConfiguration();
    }

    public void setPermittedOptions(CommandLineOptions options) {
        options.addRecognizedOption("config", 258, "Use specified configuration file");
        options.addRecognizedOption("catalog", 258, "Use specified catalog file to resolve URIs");
        options.addRecognizedOption("dtd", 4, "Validate using DTD");
        options.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        options.addRecognizedOption("export", 258, "Schema output file in SCM format");
        options.addRecognizedOption("ext", 1, "Allow calls to Java extension functions");
        options.addRecognizedOption("init", 3, "User-supplied net.sf.saxon.lib.Initializer class to initialize the Saxon Configuration");
        options.addRecognizedOption("limits", 10, "Limits for correct processing of minOccurs and maxOccurs");
        options.addRecognizedOption("opt", 261, "Use optimization level 0..10");
        options.addRecognizedOption("quit", 257, "Quit JVM if execution fails");
        options.addRecognizedOption("r", 259, "Use named URIResolver class");
        options.addRecognizedOption("report", 259, "Report XML file name for validation error reporting");
        options.addRecognizedOption("s", 263, "List of source files to be validated");
        options.addRecognizedOption("scmin", 258, "Schema input file in SCM format");
        options.addRecognizedOption("scmout", 258, "Retained synonym of -export");
        options.addRecognizedOption("stats", 258, "Statistics output file");
        options.addRecognizedOption("t", 1, "Display version and timing information, and names of schema documents loaded");
        options.addRecognizedOption("top", 6, "QName of required outermost element node");
        options.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        options.setPermittedValues("u", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("val", 260, "Apply strict or lax validation");
        options.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        options.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        options.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        options.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        options.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        options.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        options.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        options.addRecognizedOption("y", 259, "Use named XMLReader class for parsing schema documents");
        options.addRecognizedOption("?", 512, "Display command line help text");
    }

    public int doValidate(String[] args) {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> schemaFileNames = new ArrayList<String>();
        int validCount = 0;
        int invalidCount = 0;
        int unreadableCount = 0;
        String reportFileName = null;
        InvalidityReportGenerator reportHandler = null;
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        try {
            options.setActualOptions(args);
        }
        catch (XPathException err) {
            return Validate.quit(err.getMessage(), 2);
        }
        String configFile = options.getOptionValue("config");
        if (configFile != null) {
            try {
                Configuration fconfig = Configuration.readConfiguration(new StreamSource(configFile));
                if (!(fconfig instanceof EnterpriseConfiguration)) {
                    return Validate.quit("Configuration produced from the configuration file is an instance of " + fconfig.getClass() + " (not EnterpriseConfiguration): check the value of configuration/@edition", 2);
                }
                this.config = (EnterpriseConfiguration)fconfig;
            }
            catch (XPathException e) {
                return Validate.quit(e.getMessage(), 2);
            }
        }
        if (this.config == null) {
            this.setConfiguration();
        }
        this.processor = new Processor(this.config);
        try {
            options.applyToConfiguration(this.processor);
            this.allowExit = !"off".equals(options.getOptionValue("quit"));
            String value = options.getOptionValue("?");
            if (value != null) {
                this.badUsage("");
                return 0;
            }
            value = options.getOptionValue("limits");
            if (value != null) {
                int comma = value.indexOf(44);
                if (comma < 1) {
                    this.badUsage("format: -limits:min,max");
                    return 2;
                }
                int min = Integer.parseInt(value.substring(0, comma));
                int max = Integer.parseInt(value.substring(comma + 1));
                this.config.setOccurrenceLimits(min, max);
            }
            String scmInput = options.getOptionValue("scmin");
            String scmOutput = options.getOptionValue("export");
            if (scmOutput == null) {
                scmOutput = options.getOptionValue("scmout");
            }
            if ((value = options.getOptionValue("s")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    sourceFileNames.add(tokenizer.nextToken());
                }
            }
            if ((value = options.getOptionValue("t")) != null) {
                this.processor.setConfigurationProperty("http://saxon.sf.net/feature/timing", (Object)true);
                this.showTime = true;
            }
            this.topLevelElementName = options.getOptionValue("top");
            this.useURLs = "on".equals(options.getOptionValue("u"));
            value = options.getOptionValue("val");
            if (value != null) {
                this.validationMode = value;
            }
            if ((value = options.getOptionValue("xsd")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                while (tokenizer.hasMoreTokens()) {
                    schemaFileNames.add(tokenizer.nextToken());
                }
            }
            this.xsdLanguageVersion = "1.1".equals(this.processor.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version")) ? 11 : 10;
            for (String s : options.getPositionalOptions()) {
                sourceFileNames.add(s);
            }
            this.applyLocalOptions(options, this.config);
            if (!schemaFileNames.isEmpty() && scmInput != null) {
                this.badUsage("Cannot mix xsd and scm input");
                return 2;
            }
            if (schemaFileNames.isEmpty() && scmInput == null && sourceFileNames.isEmpty()) {
                this.badUsage("No action requested");
                return 2;
            }
            if (this.showTime) {
                System.err.println(this.config.getProductTitle());
                System.err.println(Version.platform.getPlatformVersion());
            }
            this.config.displayLicenseMessage();
            this.processor.setConfigurationProperty("http://saxon.sf.net/feature/schema-validation-mode", this.validationMode);
            long startTime = new Date().getTime();
            SchemaManager manager = this.processor.getSchemaManager();
            for (String schemaFileName : schemaFileNames) {
                Source schemaSource;
                if (this.useURLs || CommandLineOptions.isImplicitURI(schemaFileName)) {
                    schemaSource = this.config.getURIResolver().resolve(schemaFileName, null);
                    if (schemaSource == null) {
                        schemaSource = this.config.getSystemURIResolver().resolve(schemaFileName, null);
                    }
                } else if (schemaFileName.equals("-")) {
                    String sysID = new File(System.getProperty("user.dir")).toURI().toASCIIString();
                    if (Version.platform.isJava()) {
                        InputSource inputSource = new InputSource(System.in);
                        inputSource.setSystemId(sysID);
                        schemaSource = new SAXSource(this.config.getStyleParser(), inputSource);
                    } else {
                        schemaSource = new StreamSource(System.in, sysID);
                    }
                } else {
                    File schemaFile = new File(schemaFileName);
                    if (!schemaFile.exists()) {
                        return Validate.quit("Schema file " + schemaFile + " does not exist", 2);
                    }
                    if (Version.platform.isJava()) {
                        InputSource eis = new InputSource(schemaFile.toURI().toString());
                        schemaSource = new SAXSource(this.config.getStyleParser(), eis);
                    } else {
                        schemaSource = new StreamSource(schemaFile.toURI().toString());
                    }
                }
                if (schemaSource == null) {
                    return Validate.quit("URIResolver for schema file must return a Source", 2);
                }
                try {
                    manager.load(schemaSource);
                }
                catch (SaxonApiException e) {
                    if (e.getCause() instanceof SchemaException) {
                        throw (SchemaException)e.getCause();
                    }
                    throw e;
                }
            }
            if (scmInput != null) {
                StreamSource scm = new StreamSource(new File(scmInput));
                manager.importComponents(scm);
            }
            if (this.showTime && !schemaFileNames.isEmpty()) {
                long endTime = new Date().getTime();
                System.err.println("Schema checking successful. Time: " + (endTime - startTime) + "ms. Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000L + "Mb.");
            }
            final SchemaValidator validator = manager.newSchemaValidator();
            validator.setLax("lax".equals(this.validationMode));
            if (this.topLevelElementName != null) {
                validator.setDocumentElementName(QName.fromClarkName(this.topLevelElementName));
            }
            if (options.definesParameterValues()) {
                options.setParams(this.processor, new CommandLineOptions.ParamSetter(){

                    @Override
                    public void setParam(QName qName, XdmValue value) {
                        validator.setParameter(qName, value);
                    }
                });
            }
            Serializer statsSerializer = null;
            value = options.getOptionValue("stats");
            if (value != null) {
                validator.setCollectStatistics(true);
                File statsFile = new File(value);
                statsSerializer = this.processor.newSerializer(statsFile);
                statsSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                statsSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            }
            if ((value = options.getOptionValue("report")) != null) {
                String reportXsdVersion;
                reportFileName = value;
                Serializer reportDestination = this.processor.newSerializer();
                reportDestination.setOutputProperty(Serializer.Property.INDENT, "yes");
                reportDestination.setOutputFile(new File(reportFileName));
                validator.setValidityReporting(reportDestination);
                reportHandler = (InvalidityReportGenerator)validator.getInvalidityHandler();
                String reportSchemaNames = options.getOptionValue("xsd");
                if (reportSchemaNames != null) {
                    reportHandler.setSchemaName(reportSchemaNames);
                }
                if ((reportXsdVersion = options.getOptionValue("xsdversion")) != null) {
                    reportHandler.setXsdVersion(reportXsdVersion);
                }
            } else {
                validator.setInvalidityHandler(new StandardInvalidityHandler(this.config));
            }
            if (sourceFileNames.size() > 1) {
                ArrayList sources = new ArrayList(sourceFileNames.size());
                for (String sourceFileName : sourceFileNames) {
                    Source source = Validate.loadDocument(sourceFileName, this.useURLs, this.config);
                    sources.add(source);
                }
                validator.validateMultiple(sources);
            } else {
                for (String sourceFileName : sourceFileNames) {
                    try {
                        XMLReader parser;
                        Source source = Validate.loadDocument(sourceFileName, this.useURLs, this.config);
                        this.processFile(source, validator);
                        if (this.showTime) {
                            System.err.println("Validation successful");
                        }
                        ++validCount;
                        if (!(source instanceof SAXSource) || (parser = ((SAXSource)source).getXMLReader()) == null) continue;
                        this.config.reuseSourceParser(parser);
                    }
                    catch (SaxonApiException e) {
                        if (e.getCause() instanceof ValidationException) {
                            if (this.showTime) {
                                System.err.println("Validation complete: errors found");
                            } else {
                                System.err.println("Validation of file " + sourceFileName + " completed: errors found");
                            }
                            ++invalidCount;
                            continue;
                        }
                        System.err.println("Failed to process file " + sourceFileName + ": " + e.getMessage());
                        ++unreadableCount;
                    }
                }
                if (this.showTime && validCount + invalidCount > 1) {
                    System.err.println(validCount + " valid document" + (validCount == 1 ? "" : "s") + "; " + invalidCount + " invalid document" + (invalidCount == 1 ? "" : "s") + (unreadableCount == 0 ? "" : "; " + unreadableCount + " unreadable or ill-formed document" + (unreadableCount == 1 ? "" : "s")));
                }
            }
            if (statsSerializer != null) {
                validator.reportValidationStatistics(statsSerializer);
            }
            if (scmOutput != null) {
                File scmOutputFile = new File(scmOutput);
                Serializer scmSerializer = this.processor.newSerializer(scmOutputFile);
                scmSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                scmSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                manager.exportComponents(scmSerializer);
                if (this.showTime) {
                    System.err.println("Schema component model written to " + scmOutputFile.getAbsolutePath());
                }
            }
        }
        catch (SchemaException err) {
            return Validate.quit("Schema processing failed: " + err.getMessage(), 2);
        }
        catch (ValidationException err) {
            this.config.reportFatalError(err);
            return Validate.quit("Validation of source document failed", 2);
        }
        catch (XPathException err) {
            this.config.reportFatalError(err);
            return Validate.quit("Processing failed", 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            return Validate.quit("Validation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            return Validate.quit("Fatal error during validation: " + err2.getMessage(), 2);
        }
        if (unreadableCount > 0) {
            return 2;
        }
        if (invalidCount > 0) {
            return 1;
        }
        return 0;
    }

    protected void applyLocalOptions(CommandLineOptions options, Configuration config) {
    }

    protected static int quit(String message, int code) {
        System.err.println(message);
        return code;
    }

    public static Source loadDocument(String sourceFileName, boolean useURLs, Configuration config) throws XPathException {
        Source sourceInput;
        if (useURLs || CommandLineOptions.isImplicitURI(sourceFileName)) {
            try {
                sourceInput = config.getURIResolver().resolve(sourceFileName, null);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
            if (sourceInput == null) {
                sourceInput = config.getSystemURIResolver().resolve(sourceFileName, null);
            }
        } else if (sourceFileName.equals("-")) {
            String sysID = new File(System.getProperty("user.dir")).toURI().toASCIIString();
            if (Version.platform.isJava()) {
                InputSource inputSource = new InputSource(System.in);
                inputSource.setSystemId(sysID);
                sourceInput = new SAXSource(config.getSourceParser(), inputSource);
            } else {
                sourceInput = new StreamSource(System.in, sysID);
            }
        } else {
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                throw new XPathException("Source file " + sourceFile + " does not exist");
            }
            if (Version.platform.isJava()) {
                InputSource eis = new InputSource(sourceFile.toURI().toString());
                sourceInput = new SAXSource(config.getSourceParser(), eis);
            } else {
                sourceInput = new StreamSource(sourceFile.toURI().toString());
            }
        }
        return sourceInput;
    }

    public void processFile(Source source, SchemaValidator validator) throws SaxonApiException {
        if (this.showTime) {
            System.err.println("Processing " + source.getSystemId());
        }
        long startTime = new Date().getTime();
        for (int r = 0; r < this.repeat; ++r) {
            validator.validate(source);
        }
        if (this.showTime) {
            long endTime = new Date().getTime();
            System.err.println("Validation time: " + (endTime - startTime) + "ms. Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000L + "Mb.");
        }
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println(this.config.getProductTitle());
        }
        System.err.println("Usage: see http://www.saxonica.com/documentation/index.html#!schema-processing/commandline");
        System.err.println("Format: " + this.getClass().getName() + " options");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        if (this.allowExit) {
            if ("".equals(message)) {
                System.exit(0);
            } else {
                System.exit(2);
            }
        } else {
            throw new RuntimeException(message);
        }
    }
}

