/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ElementCreatorCompiler;
import com.saxonica.ee.bytecode.FixedAttributeCompiler;
import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Label;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.TableSwitchGenerator;
import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Copy;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationFailure;

public class CopyCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(final CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        final Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        CopyCompiler.visitLineNumber(compiler, ga, expression);
        final Copy copyInstr = (Copy)expression;
        ItemType resultItemType = copyInstr.getItemType();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
        final int selectedItemVar = mi.allocateLocal(Item.class);
        ga.storeLocal(selectedItemVar);
        final LabelInfo copyEnd = mi.newLabel("copyEnd");
        if (th.isSubType(resultItemType, NodeKindTest.DOCUMENT)) {
            this.compileCopyDocument(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, NodeKindTest.ELEMENT)) {
            this.compileCopyElement(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, NodeKindTest.ATTRIBUTE)) {
            CopyCompiler.compileCopyAttribute(compiler, copyInstr, selectedItemVar, copyInstr.isPreservingTypes());
        } else if (th.isSubType(resultItemType, NodeKindTest.TEXT)) {
            CopyCompiler.compileCopyText(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, NodeKindTest.COMMENT)) {
            CopyCompiler.compileCopyComment(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, NodeKindTest.PROCESSING_INSTRUCTION)) {
            CopyCompiler.compileCopyProcessingInstruction(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, NodeKindTest.NAMESPACE)) {
            CopyCompiler.compileCopyNamespace(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, BuiltInAtomicType.ANY_ATOMIC)) {
            CopyCompiler.compileCopyNonNode(compiler, copyInstr, selectedItemVar);
        } else if (th.isSubType(resultItemType, AnyFunctionType.getInstance())) {
            CopyCompiler.compileCopyNonNode(compiler, copyInstr, selectedItemVar);
        } else {
            if (th.relationship(resultItemType, BuiltInAtomicType.ANY_ATOMIC) != 4 || th.relationship(resultItemType, AnyFunctionType.getInstance()) != 4) {
                LabelInfo copyNode = mi.newLabel("copyNode");
                ga.loadLocal(selectedItemVar);
                ga.ifInstance(NodeInfo.class, copyNode);
                CopyCompiler.compileCopyNonNode(compiler, copyInstr, selectedItemVar);
                ga.goTo(copyEnd);
                mi.placeLabel(copyNode);
            }
            ga.loadLocal(selectedItemVar);
            ga.checkClass(NodeInfo.class);
            ga.invokeInstanceMethod(NodeInfo.class, "getNodeKind", new Class[0]);
            final ArrayList errors = new ArrayList();
            ga.tableSwitch(new int[]{1, 2, 3, 7, 8, 9, 13}, new TableSwitchGenerator(){

                @Override
                public void generateCase(int key, Label end) {
                    try {
                        switch (key) {
                            case 9: {
                                CopyCompiler.this.compileCopyDocument(compiler, copyInstr, selectedItemVar);
                                ga.goTo(end);
                                break;
                            }
                            case 1: {
                                CopyCompiler.this.compileCopyElement(compiler, copyInstr, selectedItemVar);
                                ga.goTo(end);
                                break;
                            }
                            case 2: {
                                CopyCompiler.compileCopyAttribute(compiler, copyInstr, selectedItemVar, copyInstr.isPreservingTypes());
                                ga.goTo(end);
                                break;
                            }
                            case 3: {
                                CopyCompiler.compileCopyText(compiler, copyInstr, selectedItemVar);
                                ga.goTo(end);
                                break;
                            }
                            case 8: {
                                CopyCompiler.compileCopyComment(compiler, copyInstr, selectedItemVar);
                                ga.goTo(end);
                                break;
                            }
                            case 7: {
                                CopyCompiler.compileCopyProcessingInstruction(compiler, copyInstr, selectedItemVar);
                                ga.goTo(end);
                                break;
                            }
                            case 13: {
                                CopyCompiler.compileCopyNamespace(compiler, copyInstr, selectedItemVar);
                                ga.goTo(end);
                            }
                        }
                    }
                    catch (CannotCompileException e) {
                        errors.add(e);
                    }
                }

                @Override
                public void generateDefault() {
                    ga.goTo(copyEnd);
                }
            }, true);
            if (!errors.isEmpty()) {
                throw (CannotCompileException)errors.get(0);
            }
        }
        mi.placeLabel(copyEnd);
        mi.releaseLocal(selectedItemVar);
    }

    private void compileCopyDocument(CompilerService compiler, Copy expression, int selectedItemVar) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        CopyCompiler.visitAnnotation(compiler, "Copy - Document");
        if (expression.isPreservingTypes()) {
            compiler.generateGetReceiver();
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "startDocument", Integer.TYPE);
            this.compileCopyUnparsedEntities(compiler, selectedItemVar);
            compiler.compileToPush(expression.getContentExpression());
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "endDocument", new Class[0]);
        } else {
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "getPipelineConfiguration", new Class[0]);
            CopyCompiler.allocateStatic(compiler, compiler.getConfiguration());
            compiler.generateGetReceiver();
            ga.loadLocal(selectedItemVar);
            ga.checkClass(NodeInfo.class);
            ga.invokeInstanceMethod(NodeInfo.class, "getBaseURI", new Class[0]);
            ga.invokeDefaultConstructor(ParseOptions.class);
            ga.dup();
            ga.push(expression.getValidationAction());
            ga.invokeInstanceMethod(ParseOptions.class, "setSchemaValidationMode", Integer.TYPE);
            ga.dup();
            ga.push(0);
            ga.invokeInstanceMethod(ParseOptions.class, "setStripSpace", Integer.TYPE);
            if (expression.getSchemaType() != null) {
                ga.dup();
                CopyCompiler.allocateStatic(compiler, expression.getSchemaType());
                ga.invokeInstanceMethod(ParseOptions.class, "setTopLevelType", SchemaType.class);
            }
            CopyCompiler.allocateStatic(compiler, expression.getLocation());
            ga.invokeInstanceMethod(Configuration.class, "getDocumentValidator", Receiver.class, String.class, ParseOptions.class, Location.class);
            ga.dup();
            compiler.generateGetReceiver();
            LabelInfo differentReceiver = mi.newLabel("differentReceiver");
            LabelInfo startDocument = mi.newLabel("startDocument");
            ga.ifNotSameObject(differentReceiver);
            ga.swap();
            ga.pop();
            ga.goTo(startDocument);
            mi.placeLabel(differentReceiver);
            ga.newInstance(TreeReceiver.class);
            ga.dupX1();
            ga.swap();
            ga.invokeConstructor(TreeReceiver.class, Receiver.class);
            ga.swap();
            ga.dup2();
            ga.invokeInstanceMethod(Receiver.class, "setPipelineConfiguration", PipelineConfiguration.class);
            ga.pop();
            mi.placeLabel(startDocument);
            ga.checkClass(SequenceReceiver.class);
            compiler.pushNewReceiverInfo(ga);
            compiler.generateGetReceiver();
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "startDocument", Integer.TYPE);
            this.compileCopyUnparsedEntities(compiler, selectedItemVar);
            compiler.compileToPush(expression.getContentExpression());
            compiler.generateGetReceiver();
            ga.invokeInstanceMethod(Receiver.class, "endDocument", new Class[0]);
            compiler.popReceiverInfo();
        }
    }

    private void compileCopyUnparsedEntities(CompilerService compiler, int selectedItemVar) {
        Generator ga = compiler.getCurrentGenerator();
        ga.loadLocal(selectedItemVar);
        compiler.generateGetReceiver();
        ga.invokeStaticMethod(Copy.class, "copyUnparsedEntities", NodeInfo.class, Receiver.class);
    }

    private void compileCopyElement(CompilerService compiler, Copy expression, int selectedItemVar) throws CannotCompileException {
        int properties;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        CopyCompiler.visitAnnotation(compiler, "Copy - Element");
        Expression content = expression.getContentExpression();
        Location locationId = expression.getLocation();
        int n = properties = expression.isInheritNamespacesToChildren() ? 0 : 128;
        if (!expression.isInheritNamespacesFromParent()) {
            properties |= 0x10000;
        }
        boolean needsNameCodeVar = true;
        int nodeNameVar = ga.newLocal(NodeName.class);
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeStaticMethod(NameOfNode.class, "makeName", NodeInfo.class);
        ga.storeLocal(nodeNameVar);
        if (!expression.isPreservingTypes()) {
            if (expression.getValidationAction() == 4) {
                ElementCreatorCompiler.addTypeStripper(compiler);
            } else {
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
                compiler.generateGetReceiver();
                ga.invokeDefaultConstructor(ParseOptions.class);
                ga.dup();
                ga.push(expression.getValidationAction());
                ga.invokeInstanceMethod(ParseOptions.class, "setSchemaValidationMode", Integer.TYPE);
                if (expression.getSchemaType() != null) {
                    ga.dup();
                    CopyCompiler.allocateStatic(compiler, expression.getSchemaType());
                    ga.invokeInstanceMethod(ParseOptions.class, "setTopLevelType", SchemaType.class);
                }
                ga.dup();
                ga.loadLocal(selectedItemVar);
                ga.checkClass(NodeInfo.class);
                ga.invokeStaticMethod(Navigator.class, "getNodeName", NodeInfo.class);
                ga.invokeInstanceMethod(ParseOptions.class, "setTopLevelElement", StructuredQName.class);
                CopyCompiler.allocateStatic(compiler, expression.getLocation());
                ga.invokeInstanceMethod(Configuration.class, "getElementValidator", Receiver.class, ParseOptions.class, Location.class);
                int validatorVar = methodInfo.allocateLocal(Receiver.class);
                ga.storeLocal(validatorVar);
                ga.loadLocal(validatorVar);
                compiler.generateGetReceiver();
                LabelInfo sameReceiver = methodInfo.newLabel("sameReceiver");
                LabelInfo doneReceiver = methodInfo.newLabel("doneReceiver");
                ga.ifSameObject(sameReceiver);
                ga.newInstance(Type.getType(TreeReceiver.class));
                ga.dup();
                ga.loadLocal(validatorVar);
                ga.invokeConstructor(TreeReceiver.class, Receiver.class);
                ga.goTo(doneReceiver);
                methodInfo.placeLabel(sameReceiver);
                compiler.generateGetReceiver();
                methodInfo.placeLabel(doneReceiver);
                compiler.pushNewReceiverInfo(ga);
                methodInfo.releaseLocal(validatorVar);
            }
        }
        LabelInfo nonNullSystemId = methodInfo.newLabel("nonNullSystemId");
        CopyCompiler.visitAnnotation(compiler, "Copy - Element - Base URI");
        compiler.generateGetReceiver();
        ga.invokeInstanceMethod(Receiver.class, "getSystemId", new Class[0]);
        ga.ifNonNull(nonNullSystemId.label());
        compiler.generateGetReceiver();
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getBaseURI", new Class[0]);
        ga.invokeInstanceMethod(Receiver.class, "setSystemId", String.class);
        methodInfo.placeLabel(nonNullSystemId);
        compiler.generateGetReceiver();
        CopyCompiler.visitAnnotation(compiler, "Copy - Element - NameOfNode");
        ga.loadLocal(nodeNameVar);
        Enum typeCode = expression.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
        CopyCompiler.allocateStatic(compiler, typeCode);
        CopyCompiler.allocateStatic(compiler, locationId);
        ga.push(properties);
        ga.invokeInstanceMethod(Receiver.class, "startElement", NodeName.class, SchemaType.class, Location.class, Integer.TYPE);
        if (expression.isCopyNamespaces()) {
            ga.loadLocal(selectedItemVar);
            compiler.generateGetReceiver();
            ga.invokeStaticMethod(NamespaceIterator.class, "sendNamespaces", NodeInfo.class, Receiver.class);
        } else {
            compiler.generateGetReceiver();
            ga.loadLocal(nodeNameVar);
            ga.invokeInstanceMethod(NodeName.class, "getNamespaceBinding", new Class[0]);
            ga.push(0);
            ga.invokeInstanceMethod(Receiver.class, "namespace", NamespaceBindingSet.class, Integer.TYPE);
        }
        compiler.compileToPush(content);
        compiler.generateGetReceiver();
        ga.invokeInstanceMethod(Receiver.class, "endElement", new Class[0]);
        if (!expression.isPreservingTypes()) {
            compiler.popReceiverInfo();
        }
        methodInfo.releaseLocal(nodeNameVar);
    }

    protected static void compileCopyAttribute(CompilerService compiler, ValidatingInstruction expression, int selectedItemVar, boolean preserveTypes) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        int nodeNameVar = mi.allocateLocal(NodeName.class);
        CopyCompiler.visitAnnotation(compiler, "Copy_Attribute");
        LabelInfo nonEmptyFi = mi.newLabel("nonEmptyFi");
        compiler.generateGetReceiver();
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeStaticMethod(NameOfNode.class, "makeName", NodeInfo.class);
        ga.storeLocal(nodeNameVar);
        ga.loadLocal(nodeNameVar);
        SchemaType schemaType = expression.getSchemaType();
        if (schemaType != null) {
            if (schemaType.isSimpleType()) {
                CopyCompiler.visitAnnotation(compiler, "Copy_Attribute_withType");
                if (((SimpleType)schemaType).isNamespaceSensitive()) {
                    compiler.generateDynamicError("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)", "XTTE1545", ((Expression)((Object)expression)).getLocation(), true);
                } else {
                    CopyCompiler.allocateStatic(compiler, schemaType);
                    ga.loadLocal(selectedItemVar);
                    ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
                    CopyCompiler.allocateStatic(compiler, DummyNamespaceResolver.getInstance());
                    CopyCompiler.allocateStatic(compiler, compiler.getConfiguration().getConversionRules());
                    ga.invokeInstanceMethod(SimpleType.class, "validateContent", CharSequence.class, NamespaceResolver.class, ConversionRules.class);
                    LabelInfo validationOk = mi.newLabel("validationOk");
                    ga.dup();
                    ga.ifNull(validationOk.label());
                    ga.dup();
                    ga.dup();
                    ga.invokeInstanceMethod(ValidationFailure.class, "getMessage", new Class[0]);
                    ga.push("Attribute being copied does not match the required type. ");
                    ga.swap();
                    ga.concatenateStrings(2);
                    ga.invokeInstanceMethod(ValidationFailure.class, "setMessage", String.class);
                    ga.invokeInstanceMethod(ValidationFailure.class, "makeException", new Class[0]);
                    ga.throwException();
                    mi.placeLabel(validationOk);
                    ga.pop();
                    CopyCompiler.allocateStatic(compiler, schemaType);
                    ga.loadLocal(selectedItemVar);
                    ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
                    CopyCompiler.allocateStatic(compiler, ((Expression)((Object)expression)).getLocation());
                    ga.push(0);
                    ga.invokeInstanceMethod(Receiver.class, "attribute", NodeName.class, SimpleType.class, CharSequence.class, Location.class, Integer.TYPE);
                }
            } else {
                compiler.generateDynamicError("Cannot validate an attribute against a complex type", "XTTE1535", ((Expression)((Object)expression)).getLocation(), true);
            }
            return;
        }
        if (preserveTypes) {
            ga.loadLocal(selectedItemVar);
            ga.checkClass(NodeInfo.class);
            ga.invokeInstanceMethod(NodeInfo.class, "getSchemaType", new Class[0]);
            ga.dup();
            LabelInfo notSensitive = mi.newLabel("notSensitive");
            ga.getStaticField(BuiltInAtomicType.class, "UNTYPED_ATOMIC", BuiltInAtomicType.class);
            ga.invokeInstanceMethod(Object.class, "equals", Object.class);
            ga.ifTrue(notSensitive);
            ga.dup();
            ga.checkClass(SimpleType.class);
            ga.invokeInstanceMethod(SimpleType.class, "isNamespaceSensitive", new Class[0]);
            ga.ifFalse(notSensitive);
            compiler.generateDynamicError("Cannot preserve type annotation when copying an attribute with namespace-sensitive content", ((Instruction)((Object)expression)).getPackageData().getHostLanguage() == 50 ? "XTTE0950" : "XQTY0086", ((Expression)((Object)expression)).getLocation(), true);
            mi.placeLabel(notSensitive);
            ga.checkClass(SimpleType.class);
        } else {
            ga.getStaticField(BuiltInAtomicType.class, "UNTYPED_ATOMIC", BuiltInAtomicType.class);
        }
        ga.loadLocal(selectedItemVar);
        ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        FixedAttributeCompiler.generateAttributeValidationPushCode(compiler, expression, null, nodeNameVar);
        CopyCompiler.allocateStatic(compiler, ((Expression)((Object)expression)).getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "attribute", NodeName.class, SimpleType.class, CharSequence.class, Location.class, Integer.TYPE);
    }

    protected static void compileCopyNamespace(CompilerService compiler, Expression expression, int selectedItemVar) {
        Generator ga = compiler.getCurrentGenerator();
        CopyCompiler.visitAnnotation(compiler, "Copy - Namespace");
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        compiler.generateGetReceiver();
        ga.push(0);
        CopyCompiler.allocateStatic(compiler, expression.getLocation());
        ga.invokeInstanceMethod(NodeInfo.class, "copy", Receiver.class, Integer.TYPE, Location.class);
    }

    protected static void compileCopyText(CompilerService compiler, Expression expression, int selectedItemVar) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        CopyCompiler.visitAnnotation(compiler, "Copy - Text");
        compiler.generateGetReceiver();
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getStringValueCS", new Class[0]);
        LabelInfo nonEmptyFi = mi.newLabel("nonEmptyFi");
        CopyCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "characters", CharSequence.class, Location.class, Integer.TYPE);
    }

    protected static void compileCopyComment(CompilerService compiler, Expression expression, int selectedItemVar) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        CopyCompiler.visitAnnotation(compiler, "Copy - Comment");
        compiler.generateGetReceiver();
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getStringValueCS", new Class[0]);
        CopyCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "comment", CharSequence.class, Location.class, Integer.TYPE);
    }

    protected static void compileCopyProcessingInstruction(CompilerService compiler, Expression expression, int selectedItemVar) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        CopyCompiler.visitAnnotation(compiler, "Copy - PI");
        compiler.generateGetReceiver();
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getDisplayName", new Class[0]);
        ga.loadLocal(selectedItemVar);
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getStringValueCS", new Class[0]);
        LabelInfo nonEmptyFi = mi.newLabel("nonEmptyFi");
        CopyCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(0);
        ga.invokeInstanceMethod(Receiver.class, "processingInstruction", String.class, CharSequence.class, Location.class, Integer.TYPE);
    }

    protected static void compileCopyNonNode(CompilerService compiler, Expression expression, int selectedItemVar) {
        Generator ga = compiler.getCurrentGenerator();
        CopyCompiler.visitAnnotation(compiler, "Copy_NonNode");
        compiler.generateGetReceiver();
        ga.loadLocal(selectedItemVar);
        CopyCompiler.allocateStatic(compiler, expression.getLocation());
        ga.push(524288);
        ga.invokeInstanceMethod(Receiver.class, "append", Item.class, Location.class, Integer.TYPE);
    }
}

