/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.optim.SwitchExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class SwitchExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileGeneric(compiler, expression, 1);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileGeneric(compiler, expression, 4);
    }

    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        this.compileGeneric(compiler, expression, 2);
    }

    private void compileGeneric(CompilerService compiler, Expression expression, int evaluationMode) throws CannotCompileException {
        SwitchExpression switcher = (SwitchExpression)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        String modeName = "";
        switch (evaluationMode) {
            case 1: {
                modeName = "Item";
                break;
            }
            case 2: {
                modeName = "Itr";
                break;
            }
            case 4: {
                modeName = "Push";
            }
        }
        SwitchExpressionCompiler.visitAnnotation(compiler, "SwitchExpressionCompiler-" + modeName);
        SwitchExpressionCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo done = methodInfo.newLabel("SwitchDone");
        LabelInfo otherwise = methodInfo.newLabel("SwitchOtherwise");
        LabelInfo foundCase = methodInfo.newLabel("SwitchFoundCase");
        Expression subject = switcher.getSubjectExpression();
        compiler.compileToItem(subject);
        if (Cardinality.allowsZero(subject.getCardinality())) {
            LabelInfo notNull = methodInfo.newLabel("SwitchNotNull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.goTo(otherwise);
            methodInfo.placeLabel(notNull);
        }
        ga.checkClass(AtomicValue.class);
        ga.push(false);
        SwitchExpressionCompiler.allocateStatic(compiler, switcher.getCollation());
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getImplicitTimezone", new Class[0]);
        ga.invokeInstanceMethod(AtomicValue.class, "getXPathComparable", Boolean.TYPE, StringCollator.class, Integer.TYPE);
        SwitchExpressionCompiler.allocateStatic(compiler, this.compileMap(compiler, switcher, evaluationMode));
        ga.swap();
        ga.invokeInstanceMethod(Map.class, "get", Object.class);
        ga.dup();
        ga.ifNonNull(foundCase.label());
        ga.pop();
        ga.goTo(otherwise);
        methodInfo.placeLabel(foundCase);
        ga.checkClass(Expression.class);
        compiler.generateGetContext();
        switch (evaluationMode) {
            case 1: {
                ga.invokeInstanceMethod(Expression.class, "evaluateItem", XPathContext.class);
                break;
            }
            case 2: {
                ga.invokeInstanceMethod(Expression.class, "iterate", XPathContext.class);
                break;
            }
            case 4: {
                ga.invokeInstanceMethod(Expression.class, "process", XPathContext.class);
            }
        }
        ga.goTo(done);
        methodInfo.placeLabel(otherwise);
        switch (evaluationMode) {
            case 1: {
                compiler.compileToItem(switcher.getOtherwiseExpression());
                break;
            }
            case 2: {
                compiler.compileToIterator(switcher.getOtherwiseExpression());
                break;
            }
            case 4: {
                compiler.compileToPush(switcher.getOtherwiseExpression());
            }
        }
        methodInfo.placeLabel(done);
    }

    private Map<AtomicMatchKey, Expression> compileMap(CompilerService compiler, SwitchExpression switcher, int evaluationMode) throws CannotCompileException {
        Map<AtomicMatchKey, Integer> cases = switcher.getCaseMap();
        HashMap<AtomicMatchKey, Expression> out = new HashMap<AtomicMatchKey, Expression>(cases.size());
        List<Operand> actions = switcher.getActions();
        ArrayList<CompiledExpression> compiledActions = new ArrayList<CompiledExpression>();
        for (int i = 0; i < actions.size(); ++i) {
            CompiledExpression ce = compiler.compileToByteCode(actions.get(i).getChildExpression(), "case" + i, evaluationMode);
            if (ce == null) {
                throw new CannotCompileException(actions.get(i).getChildExpression());
            }
            compiledActions.add(ce);
        }
        for (Map.Entry<AtomicMatchKey, Integer> e : cases.entrySet()) {
            out.put(e.getKey(), (Expression)compiledActions.get(e.getValue()));
        }
        return out;
    }
}

