/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.validate.ValidationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.ValidationParams;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class Assertion
extends SchemaStructure
implements SchemaComponent,
SerializableSchemaComponent {
    private XPathExpression condition;
    private XPathVariable valueVariable;
    private Map<StructuredQName, XPathVariable> declaredParams;
    private String conditionText;
    private String message;
    private XPathStaticContext staticContext;

    public Assertion() {
    }

    public Assertion(EnterpriseConfiguration config, XPathExpression condition, XPathVariable valueVariable, Map<StructuredQName, XPathVariable> params, String text) {
        this.setConfiguration(config);
        this.condition = condition;
        this.valueVariable = valueVariable;
        this.declaredParams = params;
        this.conditionText = text;
    }

    public XPathExpression getCondition() {
        return this.condition;
    }

    public XPathVariable getValueVariable() {
        return this.valueVariable;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStaticContext(XPathStaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public XPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public boolean testSimple(AtomicSequence value, ConversionRules rules) {
        XPathDynamicContext context;
        Configuration config;
        if (rules instanceof ValidationContext) {
            try {
                Controller controller = ((ValidationContext)rules).getController();
                config = controller.getConfiguration();
                ValidationParams actualParams = ((ValidationContext)rules).getValidationParams();
                context = this.condition.createDynamicContext(controller, null);
                ValidationParams.setValidationParams(this.declaredParams, actualParams, context);
            }
            catch (XPathException err) {
                throw new IllegalStateException(err.getMessage());
            }
        } else {
            context = this.condition.createDynamicContext();
            Controller controller = context.getXPathContextObject().getController();
            config = this.staticContext.getConfiguration();
        }
        Assertion.setDocumentsAndCollections(config, context);
        try {
            if (this.getValueVariable() != null) {
                context.setVariable(this.getValueVariable(), value == null ? EmptySequence.getInstance() : value);
            }
            return ExpressionTool.effectiveBooleanValue(this.condition.iterate(context));
        }
        catch (XPathException err) {
            context.getErrorListener().warning(err);
            return false;
        }
    }

    public List<NodeInfo> testComplex(NodeInfo contextItem, AtomicSequence value, ValidationContext rules) {
        XPathDynamicContext context;
        Configuration config;
        try {
            Controller controller = rules.getController();
            config = controller.getConfiguration();
            ValidationParams actualParams = rules.getValidationParams();
            context = this.condition.createDynamicContext(controller, contextItem);
            ValidationParams.setValidationParams(this.declaredParams, actualParams, context);
            if (this.getValueVariable() != null) {
                context.setVariable(this.getValueVariable(), value == null ? EmptySequence.getInstance() : value);
            }
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        Assertion.setDocumentsAndCollections(config, context);
        ArrayList<NodeInfo> result = new ArrayList<NodeInfo>();
        try {
            this.condition.iterate(context).forEachOrFail(item -> result.add((NodeInfo)item));
            return result;
        }
        catch (XPathException err) {
            context.getErrorListener().warning(err);
            result.add(contextItem);
            return result;
        }
    }

    public static void setDocumentsAndCollections(Configuration config, XPathDynamicContext context) {
        context.setURIResolver(new StandardURIResolver(config){

            @Override
            public Source resolve(String href, String base) throws XPathException {
                throw new XPathException("Use of doc() function within an assertion is not allowed", "FODC0002");
            }
        });
        context.getXPathContextObject().getController().setDefaultCollection(CollectionFn.EMPTY_COLLECTION_URI);
        context.setCollectionFinder((context1, collectionURI) -> {
            if (collectionURI.equals(CollectionFn.EMPTY_COLLECTION_URI)) {
                return CollectionFn.EMPTY_COLLECTION;
            }
            throw new XPathException("No collections are available when processing assertions");
        });
    }

    public int hashCode() {
        return this.condition.getInternalExpression().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof Assertion && this.condition.getInternalExpression().isEqual(((Assertion)other).condition.getInternalExpression());
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("assertion");
        serializer.emitNamespaceContext(this.staticContext.getNamespaceResolver());
        serializer.emitAttribute("test", this.getConditionText());
        serializer.emitAttribute("defaultNamespace", this.staticContext.getDefaultElementNamespace());
        serializer.emitAttribute("xml:base", this.staticContext.getStaticBaseURI());
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        Callable callable = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue("Assertion");
                }
                case "implementation": {
                    return new ObjectValue<Assertion>(this);
                }
                case "test": {
                    return SchemaStructure.makeXPathExpressionPropertyRecord(this.conditionText, this.staticContext.getNamespaceResolver(), this.staticContext.getStaticBaseURI());
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, callable, COMPONENT_FUNCTION_TYPE);
    }
}

