/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.watch.Watch;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;

public class ComponentInversion {
    private Expression body;
    private Inversion inversion;
    private SlotManager stackFrame = null;

    public ComponentInversion(Expression body) {
        this.body = body;
    }

    public Watch getWatch(WatchManager wm, Feed result, XPathContext context) throws XPathException {
        return this.inversion.getWatch(wm, result, context);
    }

    public void invert(boolean isW3CStreamable) throws XPathException {
        try {
            this.inversion = Inversion.invertExpression(this.body, false);
        }
        catch (XPathException e) {
            String frag = isW3CStreamable ? "although it is" : "and is not";
            XPathException e2 = new XPathException("Component cannot be streamed, " + frag + " guaranteed streamable according to W3C rules. " + e.getMessage(), "SXST0062");
            e2.setErrorCode(e.getErrorCodeLocalPart());
            e2.setLocator(this.body.getLocation());
            e2.setXPathContext(e.getXPathContext());
            throw e2;
        }
    }

    public void setStackFrame(SlotManager frame) {
        this.stackFrame = frame;
    }

    public SlotManager getStackFrame() {
        return this.stackFrame;
    }

    public Inversion getInversion() {
        return this.inversion;
    }

    public void explain(ExpressionPresenter presenter) throws XPathException {
        Expression exp = this.body;
        presenter.emitAttribute("line", exp.getLocation().getLineNumber() + "");
        presenter.emitAttribute("module", exp.getLocation().getSystemId());
        presenter.emitAttribute("streaming", "true");
        this.inversion.explain(presenter);
        exp.export(presenter);
    }
}

