/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Map;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.ma.json.XMLToJsonFn;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;

public class XmlToJsonFnStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Pattern selection;
        SystemFunctionCall instruction = (SystemFunctionCall)this.getExpression();
        Expression select = instruction.getArg(0);
        if (select instanceof CardinalityChecker) {
            select = ((CardinalityChecker)select).getBaseExpression();
        }
        if ((selection = StreamingPatternMaker.makeStreamingPattern(select, this.getConfiguration(), null)) != null) {
            return new WatchMaker(){

                @Override
                public Trigger makeWatch(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
                    ToJsonAction action = new ToJsonAction(XmlToJsonFnStreamer.this.getExpression(), out, context);
                    action.setWatchManager(watchManager);
                    return new Trigger(selection, action, context);
                }
            };
        }
        return null;
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        ToJsonAction action = new ToJsonAction(this.getExpression(), out, context);
        action.setWatchManager(watchManager);
        return action;
    }

    private static class ToJsonAction
    extends ItemFeed {
        private WatchManager watchManager;
        private JsonReceiver receiver;
        private boolean indenting;
        private boolean foundOneNode;

        public ToJsonAction(Expression functionCall, Feed out, XPathContext context) {
            super(functionCall, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SystemFunctionCall exp = (SystemFunctionCall)this.getExpression();
            XMLToJsonFn target = (XMLToJsonFn)exp.getTargetFunction(this.getContext());
            if (exp.getArity() > 1) {
                MapItem suppliedOptions = (MapItem)exp.getArg(1).evaluateItem(this.getContext());
                Map<String, Sequence<?>> options = target.getDetails().optionDetails.processSuppliedOptions(suppliedOptions, this.getContext());
                this.indenting = ((BooleanValue)options.get("indent").head()).getBooleanValue();
            }
        }

        public void setWatchManager(WatchManager watchManager) {
            this.watchManager = watchManager;
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.foundOneNode) {
                XPathException err = new XPathException("Supplied argument to xml-to-json contains more than one node", "XPTY0004");
                this.dynamicError(err);
                return null;
            }
            this.foundOneNode = true;
            this.getPipelineConfiguration().setComponent(StartTagBuffer.class.getName(), this.watchManager.getStartTagBuffer());
            this.receiver = new JsonReceiver(this.getPipelineConfiguration());
            this.receiver.setIndenting(this.indenting);
            this.receiver.open();
            return this.receiver;
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            throw new AssertionError();
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
        }

        @Override
        public void close() throws XPathException {
            this.receiver.close();
            String json = this.receiver.getJsonString();
            this.getResult().processItem(StringValue.makeStringValue(json));
            super.close();
        }
    }
}

