/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ContentValidator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;

public class EmptyContentValidator
extends AttributeValidator {
    private boolean allowTextNodes;
    private Location locationId;
    private FastStringBuffer buffer;
    private SchemaType schemaType;

    public EmptyContentValidator(UserComplexType type, Receiver next) throws MissingComponentException {
        super(next);
        this.schemaType = type;
        this.setAttributeGroup(type.getCombinedAttributeGroup());
        this.allowTextNodes = type.isMixedContent();
        this.setAnnotation(type);
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    public ContentValidator getChildValidator() {
        return new AnyTypeValidator(this.getNextReceiver());
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.locationId = location.saveLocation();
        String message = "Invalid child element " + Err.wrap(nameCode.getDisplayName(), 1) + ", " + this.getContainingElementName() + " has an empty content model";
        ValidationFailure ve = new ValidationFailure(message);
        ve.setConstraintReference(1, "cvc-complex-type", "2.1");
        ve.setSchemaType(this.getSchemaType());
        this.reportValidationError(ve, true, location);
        this.buffer = null;
        super.startElement(nameCode, AnyType.getInstance(), location, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        if (this.allowTextNodes) {
            ElementDecl decl = this.getElementDeclaration();
            if (decl != null && (decl.getFixedValue() != null || decl.getDefaultValueLexicalForm() != null)) {
                if (this.buffer == null) {
                    this.buffer = new FastStringBuffer(chars.length());
                }
                this.buffer.append(chars);
            }
        } else {
            String message = "Character data is not allowed: " + this.getContainingElementName() + " has an empty content model";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.1");
            ve.setSchemaType(this.getSchemaType());
            this.reportValidationError(ve, true, locationId);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        ElementDecl decl;
        if (this.isNil() && (decl = this.getElementDeclaration()) != null && decl.getFixedValue() != null) {
            String message = "An element with xsi:nil='true' must not have a fixed value";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-elt", "3.2.2");
            ve.setSchemaType(this.getSchemaType());
            this.reportValidationError(ve, true, this.locationId);
        }
        if (this.allowTextNodes && (decl = this.getElementDeclaration()) != null) {
            String defaultValue = decl.getDefaultValueLexicalForm();
            String fixedValue = decl.getFixedValueLexicalForm();
            if (defaultValue != null && (this.buffer == null || this.buffer.isEmpty())) {
                this.characters(defaultValue, ExplicitLocation.UNKNOWN_LOCATION, 0);
            } else if (fixedValue != null) {
                FastStringBuffer fsb = this.buffer;
                if (fsb == null || fsb.isEmpty()) {
                    this.characters(fixedValue, ExplicitLocation.UNKNOWN_LOCATION, 0);
                } else if (!fsb.toString().equals(fixedValue)) {
                    String message = "The content " + Err.wrap(this.buffer, 4) + " of " + this.getContainingElementName() + " does not match the fixed value " + Err.wrap(fixedValue, 4);
                    ValidationFailure ve = new ValidationFailure(message);
                    ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                    ve.setSchemaType(this.getSchemaType());
                    this.reportValidationError(ve, true, this.getContainingElementLocationId());
                }
            }
        }
        super.endElement();
    }
}

