/*
 * Decompiled with CFR 0.152.
 */
package marmot.util.edit;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import marmot.util.Counter;
import marmot.util.edit.EditTree;
import marmot.util.edit.Match;
import marmot.util.edit.MatchNode;
import marmot.util.edit.ReplaceNode;

public class EditTreeBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Counter<String> counter_ = new Counter();
    private transient Map<String, EditTree> cache_;
    private transient StringBuilder sb_;
    private Random random_;
    private int max_depth_;
    private static final char SEPARATOR = ' ';

    public EditTreeBuilder(Random random, int max_depth) {
        this.random_ = random;
        this.max_depth_ = max_depth;
    }

    public EditTree build(String input, String output) {
        this.clearCache();
        return this.build(input, 0, input.length(), output, 0, output.length(), 0);
    }

    private void clearCache() {
        if (this.cache_ == null) {
            this.cache_ = new HashMap<String, EditTree>();
        }
        this.cache_.clear();
    }

    public Counter<String> getCounter() {
        return this.counter_;
    }

    public EditTree build(String input, int input_start, int input_end, String output, int output_start, int output_end, int depth) {
        EditTree best_tree = this.retrieveFromCache(input_start, input_end, output_start, output_end);
        if (best_tree != null) {
            return best_tree;
        }
        if (this.max_depth_ < 0 || depth < this.max_depth_) {
            for (Match match : this.longestMatches(input, input_start, input_end, output, output_start, output_end)) {
                EditTree left = null;
                if (input_start < match.getInputStart() || output_start < match.getOutputStart()) {
                    left = this.build(input, input_start, match.getInputStart(), output, output_start, match.getOutputStart(), depth + 1);
                }
                EditTree right = null;
                if (match.getInputEnd() < input_end || match.getOutputEnd() < output_end) {
                    right = this.build(input, match.getInputEnd(), input_end, output, match.getOutputEnd(), output_end, depth + 1);
                }
                int left_input_length = match.getInputStart() - input_start;
                int right_input_length = input_end - match.getInputEnd();
                MatchNode tree = new MatchNode(left, right, left_input_length, right_input_length);
                if (best_tree != null && !(tree.getCost(this) < best_tree.getCost(this))) continue;
                best_tree = tree;
            }
        }
        if (best_tree == null) {
            best_tree = new ReplaceNode(input.substring(input_start, input_end), output.substring(output_start, output_end));
        }
        this.addToCache(input_start, input_end, output_start, output_end, best_tree);
        return best_tree;
    }

    private void addToCache(int input_start, int input_end, int output_start, int output_end, EditTree tree) {
        String key = this.getCacheKey(input_start, input_end, output_start, output_end);
        this.cache_.put(key, tree);
    }

    private EditTree retrieveFromCache(int input_start, int input_end, int output_start, int output_end) {
        String key = this.getCacheKey(input_start, input_end, output_start, output_end);
        return this.cache_.get(key);
    }

    private String getCacheKey(int input_start, int input_end, int output_start, int output_end) {
        if (this.sb_ == null) {
            this.sb_ = new StringBuilder();
        }
        this.sb_.setLength(0);
        this.sb_.append(Integer.toHexString(input_start));
        this.sb_.append(' ');
        this.sb_.append(Integer.toHexString(input_end));
        this.sb_.append(' ');
        this.sb_.append(Integer.toHexString(output_start));
        this.sb_.append(' ');
        this.sb_.append(Integer.toHexString(output_end));
        return this.sb_.toString();
    }

    private List<Match> longestMatches(String input, int input_start, int input_end, String output, int output_start, int output_end) {
        LinkedList<Match> longest_matches = new LinkedList<Match>();
        for (int m_input_start = input_start; m_input_start < input_end; ++m_input_start) {
            for (int m_output_start = output_start; m_output_start < output_end; ++m_output_start) {
                int o;
                int i;
                int length = 0;
                while ((i = m_input_start + length) < input_end && (o = m_output_start + length) < output_end && input.charAt(i) == output.charAt(o)) {
                    ++length;
                }
                if (length <= 0 || !longest_matches.isEmpty() && longest_matches.getFirst().getLength() > length) continue;
                if (!longest_matches.isEmpty() && longest_matches.getFirst().getLength() < length) {
                    longest_matches.clear();
                }
                longest_matches.add(new Match(m_input_start, m_output_start, length));
            }
        }
        if (this.random_ != null) {
            Collections.shuffle(longest_matches, this.random_);
        }
        return longest_matches;
    }

    public void setCounter(Counter<String> counter) {
        this.counter_ = counter;
    }
}

