/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent;

import java.io.IOException;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.RealValueFileEventStream;
import opennlp.tools.util.ObjectStream;

public class RealBasicEventStream
implements ObjectStream<Event> {
    private final ObjectStream<String> ds;

    public RealBasicEventStream(ObjectStream<String> ds) {
        this.ds = ds;
    }

    @Override
    public Event read() throws IOException {
        String eventString = this.ds.read();
        if (eventString != null) {
            return this.createEvent(eventString);
        }
        return null;
    }

    private Event createEvent(String obs) {
        int lastSpace = obs.lastIndexOf(32);
        if (lastSpace == -1) {
            return null;
        }
        String[] contexts = obs.substring(0, lastSpace).split("\\s+");
        float[] values2 = RealValueFileEventStream.parseContexts(contexts);
        return new Event(obs.substring(lastSpace + 1), contexts, values2);
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.ds.reset();
    }

    @Override
    public void close() throws IOException {
        this.ds.close();
    }
}

