/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.lemmatizer.LemmatizerContextGenerator;
import opennlp.tools.lemmatizer.LemmatizerME;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

public class LemmaSampleEventStream
extends AbstractEventStream<LemmaSample> {
    private final LemmatizerContextGenerator contextGenerator;

    public LemmaSampleEventStream(ObjectStream<LemmaSample> d, LemmatizerContextGenerator cg) {
        super(d);
        this.contextGenerator = cg;
    }

    @Override
    protected Iterator<Event> createEvents(LemmaSample sample2) {
        if (sample2 != null) {
            ArrayList<Event> events = new ArrayList<Event>();
            String[] toksArray = sample2.getTokens();
            String[] tagsArray = sample2.getTags();
            String[] lemmasArray = LemmatizerME.encodeLemmas(toksArray, sample2.getLemmas());
            int el = sample2.getTokens().length;
            for (int ei = 0; ei < el; ++ei) {
                events.add(new Event(lemmasArray[ei], this.contextGenerator.getContext(ei, toksArray, tagsArray, lemmasArray)));
            }
            return events.iterator();
        }
        return Collections.emptyListIterator();
    }
}

