/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.ValueConstraint;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.EmptySequence;

public interface ComponentWithValueConstraint {
    public ValueConstraint getValueConstraint();

    public void setValueConstraint(ValueConstraint var1);

    default public ValueConstraint getFixedValueConstraint() {
        ValueConstraint vc = this.getValueConstraint();
        if (vc != null && vc.getVariety() == ValueConstraint.Variety.FIXED) {
            return vc;
        }
        return null;
    }

    default public ValueConstraint getDefaultValueConstraint() {
        ValueConstraint vc = this.getValueConstraint();
        if (vc != null && vc.getVariety() == ValueConstraint.Variety.DEFAULT) {
            return vc;
        }
        return null;
    }

    default public Sequence<?> getValueConstraintAsFunction(ComponentWithValueConstraint att) {
        if (this.getValueConstraint() != null) {
            return this.getValueConstraint().asFunction();
        }
        return EmptySequence.getInstance();
    }

    default public String getFixedValueLexicalForm() {
        ValueConstraint vc = this.getFixedValueConstraint();
        return vc == null ? null : vc.getLexicalForm();
    }

    default public AtomicSequence getFixedValue() {
        ValueConstraint vc = this.getFixedValueConstraint();
        return vc == null ? null : vc.getValue();
    }

    default public String getDefaultValueLexicalForm() {
        ValueConstraint vc = this.getDefaultValueConstraint();
        return vc == null ? null : vc.getLexicalForm();
    }

    default public AtomicSequence getDefaultValue() {
        ValueConstraint vc = this.getDefaultValueConstraint();
        return vc == null ? null : vc.getValue();
    }

    public NamespaceResolver getNamespaceResolver();
}

