/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.InspectionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class ExistsStreamer
extends InspectionAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new ItemFeed(this.getExpression(), out, context){
            boolean found;

            @Override
            public void open(Terminator terminator) throws XPathException {
                super.open(terminator);
                this.found = false;
            }

            @Override
            public void processItem(Item<?> item) throws XPathException {
                if (!this.found) {
                    this.getResult().processItem(BooleanValue.TRUE);
                    this.getResult().close();
                    this.found = true;
                    this.getTerminator().terminate();
                }
            }

            @Override
            public void close() throws XPathException {
                if (!this.found) {
                    this.getResult().processItem(BooleanValue.FALSE);
                    this.getResult().close();
                }
            }
        };
    }
}

