/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper;

import java.util.Iterator;
import marmot.morph.mapper.Node;
import marmot.morph.mapper.SyntaxTree;
import marmot.util.ConllLineIterator;
import marmot.util.LineIterator;

public class SyntaxTreeIterator
implements Iterator<SyntaxTree> {
    int form_index_;
    int lemma_index_;
    int pos_index_;
    int feat_index_;
    int head_index_;
    int deprel_index_;
    LineIterator iterator_;
    boolean lowercase_;

    public SyntaxTreeIterator(String filename, int form_index, int lemma_index, int pos_index, int feat_index, int head_index, int deprel_index, boolean lowercase) {
        this.form_index_ = form_index;
        this.lemma_index_ = lemma_index;
        this.pos_index_ = pos_index;
        this.feat_index_ = feat_index;
        this.head_index_ = head_index;
        this.deprel_index_ = deprel_index;
        this.iterator_ = new ConllLineIterator(filename);
        this.lowercase_ = lowercase;
    }

    @Override
    public boolean hasNext() {
        return this.iterator_.hasNext();
    }

    @Override
    public SyntaxTree next() {
        SyntaxTree tree = new SyntaxTree();
        Object line = this.iterator_.next();
        while (!line.isEmpty()) {
            String form = (String)line.get(this.form_index_);
            if (this.lowercase_) {
                form = form.toLowerCase();
            }
            String lemma = (String)line.get(this.lemma_index_);
            if (this.lowercase_) {
                lemma = lemma.toLowerCase();
            }
            Node node = new Node(form, lemma, (String)line.get(this.pos_index_), (String)line.get(this.feat_index_), Integer.parseInt((String)line.get(this.head_index_)), (String)line.get(this.deprel_index_), tree);
            tree.addNode(node);
            line = this.iterator_.next();
        }
        return tree;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

