/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0096\u0002J\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\f\u0010\u0014\u001a\u00020\u0007*\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lde/ids_mannheim/korapxmltools/NonBmpString;", "", "input", "", "<init>", "(Ljava/lang/String;)V", "utf32Chars", "", "([I)V", "length", "", "getLength", "()I", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "toUtf32Array", "app"})
@SourceDebugExtension(value={"SMAP\nNonBmpString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonBmpString.kt\nde/ids_mannheim/korapxmltools/NonBmpString\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n13430#2,2:64\n*S KotlinDebug\n*F\n+ 1 NonBmpString.kt\nde/ids_mannheim/korapxmltools/NonBmpString\n*L\n40#1:64,2\n*E\n"})
public final class NonBmpString
implements CharSequence {
    @NotNull
    private final int[] utf32Chars;

    public NonBmpString(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.utf32Chars = this.toUtf32Array(input);
    }

    public NonBmpString(@NotNull int[] utf32Chars) {
        Intrinsics.checkNotNullParameter(utf32Chars, "utf32Chars");
        int[] nArray = Arrays.copyOf(utf32Chars, utf32Chars.length);
        Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
        this.utf32Chars = nArray;
    }

    public int getLength() {
        return this.utf32Chars.length;
    }

    public char get(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for NonBmpString with length " + this.length());
        }
        int codePoint = this.utf32Chars[index];
        if (!Character.isBmpCodePoint(codePoint)) {
            throw new UnsupportedOperationException("Non-BMP characters not supported directly as Char");
        }
        return (char)codePoint;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex > this.length() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("Invalid substring range");
        }
        int[] nArray = this.utf32Chars;
        int[] subArray = ArraysKt.copyOfRange(nArray, startIndex, endIndex);
        return new NonBmpString(subArray);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int[] $this$forEach$iv = this.utf32Chars;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder2;
            int element$iv;
            int codePoint = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (Character.isBmpCodePoint(codePoint)) {
                stringBuilder2 = stringBuilder.append((char)codePoint);
                continue;
            }
            stringBuilder.append(Character.highSurrogate(codePoint));
            stringBuilder2 = stringBuilder.append(Character.lowSurrogate(codePoint));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final int[] toUtf32Array(String $this$toUtf32Array) {
        int codePoint;
        int[] codePoints = new int[Character.codePointCount($this$toUtf32Array, 0, $this$toUtf32Array.length())];
        int index = 0;
        for (int offset = 0; offset < $this$toUtf32Array.length(); offset += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt($this$toUtf32Array, offset);
            codePoints[index++] = codePoint;
        }
        return codePoints;
    }
}

