/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;

public class NegateExpressionCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        NegateExpressionCompiler.visitAnnotation(compiler, "NegateExpression-Item");
        NegateExpression neg = (NegateExpression)expression;
        compiler.compileToItem(neg.getBaseExpression());
        LabelInfo negateReturn = methodInfo.newLabel("negateReturn");
        if (Cardinality.allowsZero(neg.getBaseExpression().getCardinality())) {
            LabelInfo notNull = methodInfo.newLabel("negateNotNull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            if (neg.isBackwardsCompatible()) {
                ga.getStaticField(DoubleValue.class, "NaN", DoubleValue.class);
            } else {
                ga.pushNull();
            }
            ga.goTo(negateReturn);
            methodInfo.placeLabel(notNull);
        }
        ga.checkClass(NumericValue.class);
        ga.invokeInstanceMethod(NumericValue.class, "negate", new Class[0]);
        methodInfo.placeLabel(negateReturn);
    }
}

