/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class IXSLSetAttribute
extends StyleElement {
    private Expression name;
    private Expression select;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                String nameAtt = Whitespace.trim(atts.getValue(a));
                this.name = this.makeAttributeValueTemplate(nameAtt, a);
                continue;
            }
            if (f.equals("select")) {
                String selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.name == null) {
            this.reportAbsence("name");
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression e = IXSLFunctionSet.getInstance().makeFunction("set-attribute", 2).makeFunctionCall(this.name, this.select);
        e.setRetainedStaticContext(this.makeRetainedStaticContext());
        return e;
    }
}

