/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.MaxInclusiveFacet;
import com.saxonica.ee.schema.MinExclusiveFacet;
import com.saxonica.ee.schema.MinInclusiveFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.ValueRangeFacet;
import java.math.BigInteger;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class MaxExclusiveFacet
extends ValueRangeFacet {
    @Override
    public String getName() {
        return "maxExclusive";
    }

    @Override
    protected boolean testComparisonOK(int comparisonResult) {
        return comparisonResult < 0;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        Facet other;
        super.checkFacetRestriction(type, base, compiler);
        if (this.isNewlyIntroduced(base) && (other = type.getFacet(MaxInclusiveFacet.class)) != null && other.isNewlyIntroduced(base)) {
            throw new SchemaException("Cannot specify both maxExclusive and maxInclusive facets on the same type");
        }
        ValueRangeFacet min = (ValueRangeFacet)type.getFacet(MinExclusiveFacet.class);
        if (min != null) {
            min.convertToTargetType(base, type.getConfiguration());
            if (this.requiredValue.getSchemaComparable().compareTo(min.requiredValue.getSchemaComparable()) <= 0) {
                throw new SchemaException("maxExclusive facet is less than or equal to minExclusive");
            }
        }
        if ((min = (ValueRangeFacet)type.getFacet(MinInclusiveFacet.class)) != null) {
            min.convertToTargetType(base, type.getConfiguration());
            if (this.requiredValue.getSchemaComparable().compareTo(min.requiredValue.getSchemaComparable()) <= 0) {
                throw new SchemaException("maxExclusive facet is less than or equal to minInclusive");
            }
        }
        if (base instanceof UserSimpleType) {
            min = (ValueRangeFacet)((UserSimpleType)base).getFacet(MinInclusiveFacet.class);
            if (min != null && this.requiredValue.getSchemaComparable().compareTo(min.requiredValue.getSchemaComparable()) <= 0) {
                throw new SchemaException("The value of the maxExclusive facet is less than or equal to the minInclusive facet of the base type");
            }
        } else {
            BuiltInAtomicType bbase = (BuiltInAtomicType)base;
            boolean ok = true;
            if (this.requiredValue instanceof Int64Value) {
                long v = ((Int64Value)this.requiredValue).longValue() - 1L;
                ok = IntegerValue.checkRange(v, bbase);
            } else if (this.requiredValue instanceof BigIntegerValue) {
                BigInteger v = ((BigIntegerValue)this.requiredValue).asBigInteger().subtract(BigInteger.ONE);
                ok = IntegerValue.checkBigRange(v, bbase);
            }
            if (!ok) {
                throw new SchemaException("The value of the maxExclusive facet is less than or equal to the minInclusive of the built-in base type");
            }
        }
    }
}

