/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.IOException;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.ChunkerContextGenerator;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.util.ObjectStream;

public class ChunkSampleSequenceStream
implements SequenceStream<ChunkSample> {
    private final ObjectStream<ChunkSample> samples;
    private final ChunkerContextGenerator contextGenerator;

    public ChunkSampleSequenceStream(ObjectStream<ChunkSample> samples, ChunkerContextGenerator generator) {
        this.samples = samples;
        this.contextGenerator = generator;
    }

    @Override
    public Sequence<ChunkSample> read() throws IOException {
        ChunkSample sample2 = this.samples.read();
        if (sample2 != null) {
            String[] sentence = sample2.getSentence();
            String[] tags = sample2.getTags();
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                CharSequence[] context = this.contextGenerator.getContext(i, sentence, tags, (String[])null);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence<ChunkSample>(events, sample2);
        }
        return null;
    }

    @Override
    public Event[] updateContext(Sequence<ChunkSample> sequence, AbstractModel model) {
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
    }

    @Override
    public void close() throws IOException {
        this.samples.close();
    }
}

