/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Collections;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ComponentTracer;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trace.Traceable;
import net.sf.saxon.trans.XPathException;

public class TraceExprAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        return arg == 0 ? this : super.getFeedMaker(arg);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new TraceFeed(this.getExpression(), out, context);
    }

    private static class TraceFeed
    extends ItemFeed {
        Traceable info;
        TraceListener listener;

        TraceFeed(Expression exp, ItemFeed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            Expression expr = this.getExpression();
            if (expr instanceof TraceExpression) {
                this.info = ((TraceExpression)expr).getChild();
            } else if (expr instanceof ComponentTracer) {
                this.info = ((ComponentTracer)expr).getChild();
            } else {
                throw new IllegalStateException();
            }
            if (this.getContext().getController().isTracing()) {
                this.listener = this.getContext().getController().getTraceListener();
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            if (this.listener != null) {
                this.listener.enter(this.info, Collections.emptyMap(), this.getContext());
            }
            this.getNextOutputter().append(item);
            if (this.listener != null) {
                this.listener.leave(this.info);
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.listener != null) {
                this.listener.enter(this.info, Collections.emptyMap(), this.getContext());
            }
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            if (this.listener != null) {
                this.listener.leave(this.info);
            }
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }
}

