/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;

public class InsertAttributeAction
extends PendingUpdateAction {
    private final MutableNodeInfo element;
    private final NodeName name;
    private final SimpleType typeCode;
    private final String value;
    private final int properties;
    private final boolean inherit;

    InsertAttributeAction(MutableNodeInfo element, NodeName name, SimpleType typeCode, String value, int properties, boolean inherit) {
        this.element = element;
        this.name = this.fixNodeName(name);
        this.typeCode = typeCode;
        this.value = value;
        this.properties = properties;
        this.inherit = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inherit;
    }

    @Override
    public void apply(XPathContext context, Set<MutableNodeInfo> affectedRootSet) throws XPathException {
        if (!this.element.getTreeInfo().isMutable()) {
            throw new XPathException("Attempting to update a non-updatable element", "SXUP0081");
        }
        if (this.element.getAttributeValue(this.name.getNamespaceUri(), this.name.getLocalPart()) != null) {
            throw new XPathException("Attempt to insert an attribute " + this.name.getDisplayName() + " that is already present on the target element", "XUDY0021");
        }
        affectedRootSet.add((MutableNodeInfo)this.element.getRoot());
        this.element.addAttribute(this.name, this.typeCode, this.value, this.properties, this.inherit);
        this.element.removeTypeAnnotation();
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.element;
    }

    public NodeName getAttributeName() {
        return this.name;
    }

    public SimpleType getNewTypeCode() {
        return this.typeCode;
    }

    public String getNewStringValue() {
        return this.value;
    }

    @Override
    public int getApplyPhase() {
        return 2;
    }
}

