/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanNextQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextSpans
extends SimpleSpans {
    private final Logger log = LoggerFactory.getLogger(NextSpans.class);
    public static final boolean DEBUG = false;
    private List<CandidateSpan> matchList;
    private List<CandidateSpan> candidateList;
    private int candidateListDocNum;
    private boolean hasMoreFirstSpan;

    public NextSpans(SpanNextQuery spanNextQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanNextQuery, context, acceptDocs, termContexts);
        this.collectPayloads = spanNextQuery.isCollectPayloads();
        this.hasMoreSpans = this.secondSpans.next();
        this.matchList = new ArrayList<CandidateSpan>();
        this.candidateList = new ArrayList<CandidateSpan>();
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans || !this.matchList.isEmpty() || !this.candidateList.isEmpty()) {
            if (!this.matchList.isEmpty() && this.candidateListDocNum != this.firstSpans.doc()) {
                this.matchList.clear();
                this.setMatchList();
            }
            if (!this.matchList.isEmpty()) {
                this.matchDocNumber = this.firstSpans.doc();
                this.matchStartPosition = this.firstSpans.start();
                this.matchEndPosition = this.matchList.get(0).getEnd();
                this.spanId = this.matchList.get(0).getSpanId();
                if (this.collectPayloads) {
                    this.matchPayload.addAll(this.matchList.get(0).getPayloads());
                }
                this.matchList.remove(0);
                return true;
            }
            this.hasMoreFirstSpan = this.firstSpans.next();
            if (this.hasMoreFirstSpan) {
                this.setMatchList();
                continue;
            }
            this.hasMoreSpans = false;
            this.candidateList.clear();
        }
        return false;
    }

    private void setMatchList() throws IOException {
        if (this.firstSpans.doc() == this.candidateListDocNum) {
            this.searchCandidates();
            this.searchMatches();
        } else {
            this.candidateList.clear();
            if (this.hasMoreSpans && this.ensureSameDoc(this.firstSpans, this.secondSpans)) {
                this.candidateListDocNum = this.firstSpans.doc();
                this.searchMatches();
            }
        }
    }

    private void searchCandidates() throws IOException {
        Iterator<CandidateSpan> i = this.candidateList.iterator();
        while (i.hasNext()) {
            CandidateSpan cs = i.next();
            if (cs.getStart() == this.firstSpans.end()) {
                this.addMatch(cs);
                continue;
            }
            if (cs.getEnd() >= this.firstSpans.end() || cs.getStart() >= this.firstSpans.start()) continue;
            i.remove();
        }
    }

    private void searchMatches() throws IOException {
        while (this.hasMoreSpans && this.candidateListDocNum == this.secondSpans.doc() && this.secondSpans.start() <= this.firstSpans.end()) {
            if (this.secondSpans.start() == this.firstSpans.end()) {
                this.candidateList.add(new CandidateSpan(this.secondSpans));
                this.addMatch(new CandidateSpan(this.secondSpans));
            }
            this.hasMoreSpans = this.secondSpans.next();
        }
    }

    private void addMatch(CandidateSpan cs) throws IOException {
        int start = this.firstSpans.start();
        long cost = this.firstSpans.cost() + cs.getCost();
        ArrayList<byte[]> payloads = new ArrayList<byte[]>();
        if (this.collectPayloads) {
            if (this.firstSpans.isPayloadAvailable()) {
                payloads.addAll(this.firstSpans.getPayload());
            }
            if (cs.getPayloads() != null) {
                payloads.addAll(cs.getPayloads());
            }
        }
        this.matchList.add(new CandidateSpan(start, cs.getEnd(), this.candidateListDocNum, cost, payloads));
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target) {
            if (!this.firstSpans.skipTo(target)) {
                this.hasMoreSpans = false;
                return false;
            }
            this.matchList.clear();
            if (this.hasMoreFirstSpan) {
                this.setMatchList();
            } else {
                this.hasMoreSpans = false;
                this.candidateList.clear();
            }
        }
        this.matchPayload.clear();
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost() + this.secondSpans.cost();
    }
}

