/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer;

import experimental.analyzer.Analyzer;
import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.AnalyzerReading;
import experimental.analyzer.AnalyzerTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class AnalyzerResult {
    private int num_errors_;
    private int total_;
    private double macro_pre_;
    private double macro_rec_;
    private Collection<Error> errors_;
    private int label_correct_;
    private int label_total_;

    public AnalyzerResult() {
        this(0, 0, 0.0, 0.0, new LinkedList<Error>(), 0, 0);
    }

    public AnalyzerResult(int num_errors, int total, double macro_pre, double macro_rec, Collection<Error> errors, int label_correct, int label_total) {
        this.num_errors_ = num_errors;
        this.total_ = total;
        this.macro_pre_ = macro_pre;
        this.macro_rec_ = macro_rec;
        this.errors_ = errors;
        this.label_correct_ = label_correct;
        this.label_total_ = label_total;
    }

    public void increment(AnalyzerResult result) {
        this.num_errors_ += result.num_errors_;
        this.total_ += result.total_;
        this.macro_pre_ += result.macro_pre_;
        this.macro_rec_ += result.macro_rec_;
        this.errors_.addAll(result.errors_);
        this.label_correct_ += result.label_correct_;
        this.label_total_ += result.label_total_;
    }

    public static void logResult(Analyzer analyzer, String filename) {
        AnalyzerResult.logResult(analyzer, filename, 100);
    }

    public static AnalyzerResult test(Analyzer analyzer, String filename) {
        return AnalyzerResult.test(analyzer, AnalyzerInstance.getInstances(filename));
    }

    public static AnalyzerResult test(Analyzer analyzer, Collection<AnalyzerInstance> instances) {
        AnalyzerResult result = new AnalyzerResult();
        for (AnalyzerInstance instance : instances) {
            result.increment(AnalyzerResult.test(analyzer, instance));
        }
        return result;
    }

    public static AnalyzerResult test(Analyzer analyzer, AnalyzerInstance instance) {
        HashSet<AnalyzerTag> actual = new HashSet<AnalyzerTag>(AnalyzerReading.toTags(analyzer.analyze(instance)));
        HashSet<AnalyzerTag> expected = new HashSet<AnalyzerTag>(AnalyzerReading.toTags(instance.getReadings()));
        LinkedList<AnalyzerTag> missed = new LinkedList<AnalyzerTag>();
        LinkedList<AnalyzerTag> toomuch = new LinkedList<AnalyzerTag>();
        int correct = 0;
        for (AnalyzerTag tag : actual) {
            if (expected.contains(tag)) {
                ++correct;
                continue;
            }
            toomuch.add(tag);
        }
        for (AnalyzerTag tag : expected) {
            if (actual.contains(tag)) continue;
            missed.add(tag);
        }
        int label_total = analyzer.getNumTags();
        int label_correct = label_total - (toomuch.size() + missed.size());
        double macro_pre = actual.isEmpty() ? 1.0 : (double)correct / (double)actual.size();
        double macro_rec = (double)correct / (double)expected.size();
        int total = 1;
        int num_errors = correct == actual.size() && actual.size() == expected.size() ? 0 : 1;
        List<Object> errors = missed.isEmpty() && toomuch.isEmpty() ? Collections.emptyList() : Collections.singletonList(new Error(instance, missed, toomuch));
        return new AnalyzerResult(num_errors, total, macro_pre, macro_rec, errors, label_correct, label_total);
    }

    public void logFscore() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        double recall = this.macro_rec_ / (double)this.total_;
        double prec = this.macro_pre_ / (double)this.total_;
        double macro_fsc = this.getFscore();
        logger.info(String.format("F1: %g Pr: %g Re %g", macro_fsc * 100.0, prec * 100.0, recall * 100.0));
    }

    public void logAcc() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info(String.format("Acc: %g", 100.0 * (double)(this.total_ - this.num_errors_) / (double)this.total_));
    }

    public void logLabelAcc() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.info(String.format("Label Acc: %d / %d = %g", this.label_correct_, this.label_total_, 100.0 * (double)this.label_correct_ / (double)this.label_total_));
    }

    public void logErrors(int num_errors) {
        this.logSubList(this.errors_, 0);
    }

    private void logSubList(Collection<Error> errors, int first2) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (errors.size() > first2) {
            errors = new LinkedList<Error>(errors).subList(0, first2);
        }
        StringBuilder sb = new StringBuilder("Errors:\n");
        for (Error error : errors) {
            sb.append(error.toString());
            sb.append('\n');
        }
        logger.info(sb.toString());
    }

    public double getFscore() {
        double recall = this.macro_rec_ / (double)this.total_;
        double prec = this.macro_pre_ / (double)this.total_;
        double macro_fsc = recall + prec < 1.0E-5 ? 0.0 : 2.0 * prec * recall / (prec + recall);
        return macro_fsc;
    }

    public static void logResult(Analyzer analyzer, String filename, int num_errors) {
        AnalyzerResult result = AnalyzerResult.test(analyzer, filename);
        result.logAcc();
        result.logLabelAcc();
        result.logFscore();
        result.logErrors(num_errors);
    }

    private static class Error {
        private AnalyzerInstance instance_;
        private Collection<AnalyzerTag> missed_;
        private Collection<AnalyzerTag> toomuch_;

        public Error(AnalyzerInstance instance, Collection<AnalyzerTag> missed, Collection<AnalyzerTag> tomuch) {
            this.instance_ = instance;
            this.missed_ = missed;
            this.toomuch_ = tomuch;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(String.format("%s:", this.instance_.getForm()));
            if (!this.missed_.isEmpty()) {
                sb.append(String.format(" missed: %s", this.missed_));
            }
            if (!this.toomuch_.isEmpty()) {
                sb.append(String.format(" toomuch: %s", this.toomuch_));
            }
            return sb.toString();
        }
    }
}

