/*
 * Decompiled with CFR 0.152.
 */
package experimental.ising;

import experimental.ising.DataReader;
import experimental.ising.Datum;
import experimental.ising.IsingFactorGraph;
import experimental.ising.MorphItReader;
import experimental.ising.UnaryFactor;
import experimental.ising.UnaryFeatureExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Analyzer {
    private DataReader drTrain;
    private DataReader drDev;
    private List<Datum> data;
    private List<IsingFactorGraph> trainingFactorGraphs;
    private List<IsingFactorGraph> devFactorGraphs;
    private UnaryFeatureExtractor ufe;
    private double[] parameters;
    private double[] gradient;

    public Analyzer(DataReader drTrain) {
        this.drTrain = drTrain;
        this.drDev = this.drDev;
        this.data = new LinkedList<Datum>();
        this.trainingFactorGraphs = new LinkedList<IsingFactorGraph>();
        this.devFactorGraphs = new LinkedList<IsingFactorGraph>();
        this.ufe = new UnaryFeatureExtractor(0, 5);
        System.out.println("...num variables:\t" + drTrain.numVariables);
        System.out.println("...num pairs:\t" + drTrain.pairs.size());
        int counter = 0;
        int multiple = 0;
        this.ufe.setStartFeature(0);
        this.ufe.setTotalNumVariables(drTrain.numVariables);
        for (Datum d : drTrain.data) {
            this.ufe.extract(d.getWord());
        }
        System.out.println("...num parameters:\t" + this.ufe.getNumFeatures());
        this.parameters = new double[this.ufe.getNumFeatures()];
        this.gradient = new double[this.ufe.getNumFeatures()];
        int datumI = 0;
        for (Datum d : drTrain.data) {
            System.out.println(counter + "\t" + d.getWord() + "\t" + d.getTag().size());
            ArrayList<Integer> golden = new ArrayList<Integer>();
            for (int i = 0; i < drTrain.numVariables; ++i) {
                golden.add(0);
            }
            for (Integer t2 : d.getTag()) {
                golden.set(t2, 1);
            }
            if (d.getTag().size() > 1) {
                ++multiple;
            }
            IsingFactorGraph fg = new IsingFactorGraph(d.getWord(), this.ufe, 1, drTrain.numVariables, drTrain.pairsLst, golden, drTrain.tagNames);
            if (datumI < 844) {
                this.trainingFactorGraphs.add(fg);
            } else {
                this.devFactorGraphs.add(fg);
            }
            ++counter;
            ++datumI;
        }
        this.train(50, 2.0);
        System.out.println("...train accuracy:\t" + this.decode(this.trainingFactorGraphs));
        System.out.println("...dev accuracy:\t" + this.decode(this.devFactorGraphs));
        System.exit(0);
        System.out.println("...feature dump:\t");
        for (IsingFactorGraph fg : this.trainingFactorGraphs) {
            for (UnaryFactor uf : fg.getUnaryFactor()) {
                System.out.println(uf.getTag());
                for (Integer feat : uf.getFeaturesPositive()) {
                    System.out.println(this.ufe.getInt2Feature().get(feat) + "\t" + feat);
                    System.out.println(this.ufe.getInt2Feature().get(feat + 1) + "\t" + (feat + 1));
                }
            }
        }
        System.out.println("...tag names:\t");
        System.out.println(drTrain.tagNames);
    }

    public void train(int numIterations, double eta) {
        for (int i = 0; i < this.gradient.length; ++i) {
            this.gradient[i] = 0.0;
        }
        for (int iter = 0; iter < numIterations; ++iter) {
            double likelihood = 0.0;
            for (IsingFactorGraph ig : this.trainingFactorGraphs) {
                ig.updatePotentials(this.parameters);
                ig.featurizedGradient(this.gradient, this.trainingFactorGraphs.size());
                for (int i = 0; i < this.gradient.length; ++i) {
                    int n = i;
                    this.parameters[n] = this.parameters[n] + eta * this.gradient[i];
                    this.gradient[i] = 0.0;
                }
            }
            eta *= 0.9;
            System.out.println("...iteration:\t" + iter);
            System.out.println("...likelihood:\t" + likelihood);
        }
    }

    public double decode(List<IsingFactorGraph> factorGraphs) {
        double correct = 0.0;
        int total = 0;
        for (IsingFactorGraph ig : factorGraphs) {
            System.out.println(ig);
            ig.updatePotentials(this.parameters);
            ig.inference(1, 0.01);
            List<String> decoded = ig.posteriorDecode();
            LinkedList<String> golden = new LinkedList<String>();
            int counter = 0;
            for (Integer g2 : ig.golden) {
                if (g2 == 1) {
                    String tag = this.drTrain.integer2Tag.get(counter);
                    golden.add(tag);
                }
                ++counter;
            }
            Collections.sort(decoded);
            Collections.sort(golden);
            if (decoded.equals(golden)) {
                correct += 1.0;
            } else {
                System.out.println("...word:\t" + ig.getWord());
                System.out.println("...predicted:\t" + decoded);
                System.out.println("...golden:\t" + golden);
            }
            ++total;
        }
        return correct / (double)total;
    }

    public static void main(String[] args) {
        MorphItReader drTrain = new MorphItReader(args[0]);
        new Analyzer(drTrain);
    }
}

