/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.constants.RelationDirection;
import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.SpanFocusQuery;
import de.ids_mannheim.korap.query.SpanRelationQuery;
import de.ids_mannheim.korap.query.SpanSegmentQuery;
import de.ids_mannheim.korap.query.spans.FocusSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;

public class SpanRelationMatchQuery
extends SimpleSpanQuery {
    private SpanQuery operandQuery;
    private SpanQuery operand2Query;
    private SpanRelationQuery relationQuery;

    public SpanRelationMatchQuery(SpanRelationQuery relation, SpanQuery spanQuery, boolean collectPayloads) {
        this.checkArguments(relation, spanQuery);
        SpanFocusQuery sq = new SpanFocusQuery((SpanQuery)new SpanSegmentQuery((SpanQuery)this.relationQuery, this.operandQuery, true), relation.getTempClassNumbers());
        sq.setMatchTemporaryClass(true);
        sq.setRemoveTemporaryClasses(true);
        sq.setSorted(false);
        this.setFirstClause(sq);
        this.collectPayloads = collectPayloads;
    }

    public SpanRelationMatchQuery(SpanRelationQuery relation, SpanQuery source, SpanQuery target, boolean collectPayloads) {
        this.checkArguments(relation, source, target);
        SpanFocusQuery sq = null;
        SpanFocusQuery sq2 = null;
        if (this.relationQuery.getDirection().equals((Object)RelationDirection.RIGHT)) {
            sq = new SpanFocusQuery((SpanQuery)new SpanSegmentQuery((SpanQuery)this.relationQuery, this.operandQuery, true), relation.getTempTargetNum());
            sq.setSorted(false);
            sq.setMatchTemporaryClass(true);
            sq2 = new SpanFocusQuery((SpanQuery)new SpanSegmentQuery(this.operand2Query, sq, true), relation.getTempClassNumbers());
        } else {
            sq = new SpanFocusQuery((SpanQuery)new SpanSegmentQuery((SpanQuery)this.relationQuery, this.operandQuery, true), relation.getTempSourceNum());
            sq.setMatchTemporaryClass(true);
            sq2 = new SpanFocusQuery((SpanQuery)new SpanSegmentQuery((SpanQuery)sq, this.operand2Query, true), relation.getTempClassNumbers());
        }
        sq2.setMatchTemporaryClass(true);
        sq2.setRemoveTemporaryClasses(true);
        sq2.setSorted(false);
        this.setFirstClause(sq2);
        this.collectPayloads = collectPayloads;
    }

    public void checkArguments(SpanRelationQuery relation, SpanQuery spanQuery) {
        if (relation == null) {
            throw new IllegalArgumentException("The relation query cannot be null.");
        }
        if (spanQuery == null) {
            throw new IllegalArgumentException("The operand query cannot be null.");
        }
        this.field = relation.getField();
        if (!spanQuery.getField().equals(this.field)) {
            throw new IllegalArgumentException("Clauses must have the same field.");
        }
        this.relationQuery = relation;
        this.operandQuery = spanQuery;
    }

    public void checkArguments(SpanRelationQuery relation, SpanQuery source, SpanQuery target) {
        this.checkArguments(relation, source);
        if (target == null && source == null) {
            throw new IllegalArgumentException("The target query cannot be null.");
        }
        if (!target.getField().equals(this.field)) {
            throw new IllegalArgumentException("Clauses must have the same field.");
        }
        this.operand2Query = target;
    }

    @Override
    public SimpleSpanQuery clone() {
        if (this.operand2Query != null) {
            return new SpanRelationMatchQuery((SpanRelationQuery)this.relationQuery.clone(), (SpanQuery)this.operandQuery.clone(), (SpanQuery)this.operand2Query.clone(), this.collectPayloads);
        }
        return new SpanRelationMatchQuery((SpanRelationQuery)this.relationQuery.clone(), (SpanQuery)this.operandQuery.clone(), this.collectPayloads);
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new FocusSpans((SpanFocusQuery)this.firstClause, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        return this.getFirstClause().toString();
    }
}

