/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.EmptySequence;

public class LastModified
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        long lastMod;
        URL absoluteURL;
        URI absoluteURI;
        Item item = arguments[0].head();
        if (item == null) {
            return EmptySequence.getInstance();
        }
        String suppliedURI = item.getStringValue();
        try {
            absoluteURI = ResolveURI.makeAbsolute(suppliedURI, this.getStaticBaseUriString());
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid URI passed to saxon:last-modified(). Base='" + this.getStaticBaseUriString() + " Relative='" + suppliedURI, e).withErrorCode("FODC0005");
        }
        EncodeForUri.checkPercentEncoding(absoluteURI.toString());
        try {
            absoluteURL = absoluteURI.toURL();
        }
        catch (MalformedURLException e) {
            throw new XPathException("Invalid URL passed to saxon:last-modified(). Base='" + this.getStaticBaseUriString() + " Relative='" + suppliedURI, e).withErrorCode("FODC0005");
        }
        try {
            URLConnection connection = ResourceLoader.urlConnection(absoluteURL);
            lastMod = connection.getLastModified();
        }
        catch (IOException e) {
            throw new XPathException("Cannot read from URI supplied to saxon:last-modified(). Base='" + this.getStaticBaseUriString() + " Relative='" + suppliedURI, e).withErrorCode("FODC0002");
        }
        if (lastMod == 0L) {
            return EmptySequence.getInstance();
        }
        return DateTimeValue.fromJavaTime(lastMod);
    }
}

