/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response.match;

import de.ids_mannheim.korap.response.Match;
import de.ids_mannheim.korap.response.match.Relation;
import de.ids_mannheim.korap.util.KrillString;
import java.util.HashSet;
import org.apache.lucene.util.FixedBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlightCombinatorElement {
    private static final int CONTEXT = -99997;
    public byte type;
    public int number = 0;
    public String characters;
    public boolean terminal = true;
    private static final Logger log = LoggerFactory.getLogger(Match.class);
    public static final boolean DEBUG = false;

    public HighlightCombinatorElement(byte type, int number) {
        this.type = type;
        this.number = number;
    }

    public HighlightCombinatorElement(byte type, int number, boolean terminal) {
        this.type = type;
        this.number = number;
        this.terminal = terminal;
    }

    public HighlightCombinatorElement(String characters) {
        this.type = 0;
        this.characters = characters;
    }

    public String toHTML(Match match, FixedBitSet level, byte[] levelCache, HashSet joins) {
        if (this.type == 1) {
            StringBuilder sb = new StringBuilder();
            if (this.number == -1) {
                sb.append("<mark>");
            } else if (this.number != -99997) {
                if (this.number < -1) {
                    String id = KrillString.escapeHTML(match.getPosID(match.getClassID(this.number)));
                    if (joins.contains(id)) {
                        sb.append("<span xlink:show=\"other\" data-action=\"join\" xlink:href=\"#").append(id).append("\">");
                    } else {
                        sb.append("<span xml:id=\"").append(id).append("\">");
                        joins.add(id);
                    }
                } else if (this.number >= 256) {
                    sb.append("<span ");
                    if (this.number < 2048) {
                        sb.append("title=\"").append(KrillString.escapeHTML(match.getAnnotationID(this.number))).append('\"');
                    } else {
                        Relation rel = match.getRelationID(this.number);
                        sb.append("xlink:title=\"").append(KrillString.escapeHTML(rel.annotation)).append("\" xlink:show=\"none\" xlink:href=\"#").append(KrillString.escapeHTML(match.getPosID(rel.refStart, rel.refEnd))).append('\"');
                    }
                    sb.append('>');
                } else {
                    byte pos;
                    if (levelCache[this.number] != 0) {
                        pos = levelCache[this.number];
                    } else {
                        pos = (byte)level.nextSetBit(0);
                        level.clear(pos);
                        levelCache[this.number] = pos;
                    }
                    sb.append("<mark class=\"class-").append(this.number).append(" level-").append(pos).append("\">");
                }
            }
            return sb.toString();
        }
        if (this.type == 2) {
            if (this.number == -99997) {
                return "";
            }
            if (this.number < -1 || this.number >= 256) {
                return "</span>";
            }
            if (this.number == -1) {
                return "</mark>";
            }
            if (this.terminal) {
                level.set(levelCache[this.number]);
            }
            return "</mark>";
        }
        if (this.type == 3) {
            return "<span class=\"pb\" data-after=\"" + this.number + "\"></span>";
        }
        if (this.type == 4) {
            String[] parts = match.getAnnotationID(this.number).split(":", 2);
            return "<span class=\"inline-marker\" data-key=\"" + KrillString.escapeHTML(parts[0]) + "\" data-value=\"" + KrillString.escapeHTML(parts[1]) + "\"></span>";
        }
        return KrillString.escapeHTML(this.characters);
    }

    public String toBrackets(Match match) {
        if (this.type == 1) {
            StringBuilder sb = new StringBuilder();
            if (this.number == -1) {
                sb.append("[");
            } else if (this.number != -99997) {
                if (this.number < -1) {
                    sb.append("{#");
                    sb.append(match.getClassID(this.number));
                    sb.append(':');
                } else {
                    sb.append("{");
                    if (this.number >= 256) {
                        if (this.number < 2048) {
                            sb.append(match.getAnnotationID(this.number));
                        } else {
                            Relation rel = match.getRelationID(this.number);
                            sb.append(rel.annotation);
                            sb.append('>').append(rel.refStart);
                            if (rel.refEnd != -1) {
                                sb.append('-').append(rel.refEnd);
                            }
                        }
                        sb.append(':');
                    } else if (this.number != 0) {
                        sb.append(this.number).append(':');
                    }
                }
            }
            return sb.toString();
        }
        if (this.type == 3) {
            StringBuilder sb = new StringBuilder();
            sb.append("{%");
            sb.append(this.number);
            sb.append("}");
            return sb.toString();
        }
        if (this.type == 4) {
            String[] parts = match.getAnnotationID(this.number).split(":", 2);
            StringBuilder sb = new StringBuilder();
            sb.append("{*");
            sb.append(KrillString.escapeBrackets(parts[0]));
            sb.append("=");
            sb.append(KrillString.escapeBrackets(parts[1]));
            sb.append("}");
            return sb.toString();
        }
        if (this.type == 2) {
            if (this.number == -99997) {
                return "";
            }
            if (this.number == -1) {
                return "]";
            }
            return "}";
        }
        if (this.characters == null) {
            return "";
        }
        return KrillString.escapeBrackets(this.characters);
    }
}

