/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.irishsentencebank;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.Span;
import opennlp.tools.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IrishSentenceBankDocument {
    private final List<IrishSentenceBankSentence> sentences = new ArrayList<IrishSentenceBankSentence>();

    public void add(IrishSentenceBankSentence sent) {
        this.sentences.add(sent);
    }

    public List<IrishSentenceBankSentence> getSentences() {
        return Collections.unmodifiableList(this.sentences);
    }

    private static int advanceLeft(String s2, int start) {
        int ret = start;
        for (char c : s2.toCharArray()) {
            if (c == ' ') {
                ++ret;
                continue;
            }
            return ret;
        }
        return ret;
    }

    private static int advanceRight(String s2, int start) {
        int end = s2.length() - 1;
        int ret = start + end + 1;
        for (int i = end; i > 0; --i) {
            if (s2.charAt(i) == ' ') {
                --ret;
                continue;
            }
            return ret;
        }
        return ret;
    }

    public static IrishSentenceBankDocument parse(InputStream is) throws IOException {
        IrishSentenceBankDocument document = new IrishSentenceBankDocument();
        try {
            DocumentBuilder docBuilder = XmlUtil.createDocumentBuilder();
            Document doc = docBuilder.parse(is);
            String root = doc.getDocumentElement().getNodeName();
            if (!root.equalsIgnoreCase("sentences")) {
                throw new IOException("Expected root node " + root);
            }
            NodeList nl = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node sentnode = nl.item(i);
                if (sentnode.getNodeName().equals("sentence")) {
                    String src = sentnode.getAttributes().getNamedItem("source").getNodeValue();
                    String trans = "";
                    HashMap<Integer, String> toks = new HashMap<Integer, String>();
                    HashMap<Integer, List> flx = new HashMap<Integer, List>();
                    ArrayList<Span> spans = new ArrayList<Span>();
                    NodeList sentnl = sentnode.getChildNodes();
                    int flexes = 1;
                    StringBuilder orig = new StringBuilder();
                    block24: for (int j = 0; j < sentnl.getLength(); ++j) {
                        String name = sentnl.item(j).getNodeName();
                        switch (name) {
                            case "flex": {
                                String slottmpa = sentnl.item(j).getAttributes().getNamedItem("slot").getNodeValue();
                                Integer flexslot = Integer.parseInt(slottmpa);
                                if (flexslot > flexes) {
                                    flexes = flexslot;
                                }
                                flx.computeIfAbsent(flexslot, k -> new ArrayList());
                                String tkn = sentnl.item(j).getAttributes().getNamedItem("lemma").getNodeValue();
                                ((List)flx.get(flexslot)).add(tkn);
                                continue block24;
                            }
                            case "translation": {
                                trans = sentnl.item(j).getFirstChild().getTextContent();
                                continue block24;
                            }
                            case "original": {
                                int last2 = 0;
                                NodeList orignl = sentnl.item(j).getChildNodes();
                                block25: for (int k2 = 0; k2 < orignl.getLength(); ++k2) {
                                    switch (orignl.item(k2).getNodeName()) {
                                        case "token": {
                                            String tmptok = orignl.item(k2).getFirstChild().getTextContent();
                                            spans.add(new Span(last2, last2 + tmptok.length()));
                                            String slottmpb = orignl.item(k2).getAttributes().getNamedItem("slot").getNodeValue();
                                            int tokslot = Integer.parseInt(slottmpb);
                                            if (tokslot > flexes) {
                                                flexes = tokslot;
                                            }
                                            toks.put(tokslot, tmptok);
                                            orig.append(tmptok);
                                            last2 += tmptok.length();
                                            continue block25;
                                        }
                                        case "#text": {
                                            String tmptxt = orignl.item(k2).getTextContent();
                                            orig.append(tmptxt);
                                            if (!" ".equals(tmptxt)) {
                                                spans.add(new Span(IrishSentenceBankDocument.advanceLeft(tmptxt, last2), IrishSentenceBankDocument.advanceRight(tmptxt, last2)));
                                            }
                                            last2 += tmptxt.length();
                                            continue block25;
                                        }
                                        default: {
                                            throw new IOException("Unexpected node: " + orignl.item(k2).getNodeName());
                                        }
                                    }
                                }
                                continue block24;
                            }
                            case "#text": 
                            case "#comment": {
                                continue block24;
                            }
                            default: {
                                throw new IOException("Unexpected node: " + (String)name);
                            }
                        }
                    }
                    IrishSentenceBankFlex[] flexa = new IrishSentenceBankFlex[flexes];
                    for (Map.Entry entry : toks.entrySet()) {
                        Integer flexidx = (Integer)entry.getKey();
                        String left = (String)entry.getValue();
                        if (flx.get(flexidx) == null) {
                            flexa = null;
                            break;
                        }
                        int rsize = ((List)flx.get(flexidx)).size();
                        String[] right = new String[rsize];
                        right = ((List)flx.get(flexidx)).toArray(right);
                        flexa[flexidx.intValue() - 1] = new IrishSentenceBankFlex(left, right);
                    }
                    Span[] spanout = new Span[spans.size()];
                    spanout = spans.toArray(spanout);
                    document.add(new IrishSentenceBankSentence(src, trans, orig.toString(), spanout, flexa));
                    continue;
                }
                if (sentnode.getNodeName().equals("#text") || sentnode.getNodeName().equals("#comment")) continue;
                throw new IOException("Unexpected node: " + sentnode.getNodeName());
            }
            return document;
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse IrishSentenceBank document", e);
        }
    }

    static IrishSentenceBankDocument parse(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            IrishSentenceBankDocument irishSentenceBankDocument = IrishSentenceBankDocument.parse(in);
            return irishSentenceBankDocument;
        }
    }

    public static class IrishSentenceBankFlex {
        final String surface;
        final String[] flex;

        public String getSurface() {
            return this.surface;
        }

        public String[] getFlex() {
            return this.flex;
        }

        public IrishSentenceBankFlex(String sf, String[] fl) {
            this.surface = sf;
            this.flex = fl;
        }
    }

    public static class IrishSentenceBankSentence {
        private final String source;
        private final String translation;
        private final String original;
        private final Span[] tokens;
        private final IrishSentenceBankFlex[] flex;

        public String getSource() {
            return this.source;
        }

        public String getTranslation() {
            return this.translation;
        }

        public String getOriginal() {
            return this.original;
        }

        public Span[] getTokens() {
            return this.tokens;
        }

        public IrishSentenceBankFlex[] getFlex() {
            return this.flex;
        }

        public TokenSample getTokenSample() {
            return new TokenSample(this.original, this.tokens);
        }

        public IrishSentenceBankSentence(String src, String trans, String orig, Span[] toks, IrishSentenceBankFlex[] flx) {
            this.source = src;
            this.translation = trans;
            this.original = orig;
            this.tokens = toks;
            this.flex = flx;
        }
    }
}

