/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetaField {
    ObjectMapper mapper = new ObjectMapper();
    public String type;
    public String key;
    public List<String> values = new ArrayList<String>();

    public MetaField(String key) {
        this.key = key;
    }

    public MetaField(String key, String type) {
        this.key = key;
        this.type = type;
    }

    public MetaField(String key, String type, String value) {
        this.key = key;
        this.type = type;
        this.values.add(value);
    }

    public MetaField addValue(String value) {
        this.values.add(value);
        return this;
    }

    public JsonNode toJsonNode() {
        ObjectNode json = this.mapper.createObjectNode();
        json.put("@type", "koral:field");
        json.put("key", this.key);
        if (this.type == null) {
            return json;
        }
        json.put("type", this.type);
        if (this.type.equals("type:integer")) {
            if (this.values.size() > 1) {
                ArrayNode list = json.putArray("value");
                Iterator<String> vIter = this.values.iterator();
                while (vIter.hasNext()) {
                    list.add(Integer.parseInt(vIter.next()));
                }
            } else {
                json.put("value", Integer.parseInt(this.values.get(0)));
            }
        } else if (this.values.size() > 1) {
            ArrayNode list = json.putArray("value");
            Iterator<String> vIter = this.values.iterator();
            while (vIter.hasNext()) {
                list.add(vIter.next());
            }
        } else if (this.values.size() > 0) {
            json.put("value", this.values.get(0));
        }
        return json;
    }
}

