/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import marmot.morph.mapper.MorphTag;

public class LdtMorphTag
implements MorphTag {
    public static final int PosIndex = 0;
    public static final int PersonIndex = 1;
    public static final int NumberIndex = 2;
    public static final int TenseIndex = 3;
    public static final int MoodIndex = 4;
    public static final int VoiceIndex = 5;
    public static final int GenderIndex = 6;
    public static final int CaseIndex = 7;
    public static final int DegreeIndex = 8;
    public Person person_;
    public Number number_;
    public Tense tense_;
    public Object voice_;
    public Mood mood_;
    public Gender gender_;
    public Pos pos_;
    public Case case_;
    public Degree degree_;

    public LdtMorphTag() {
        this.reset();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(9);
        sb.append(this.convert(this.pos_.toString()));
        sb.append(this.convert(this.person_.toString()));
        sb.append(this.convert(this.number_.toString()));
        sb.append(this.convert(this.tense_.toString()));
        sb.append(this.convert(this.mood_.toString()));
        sb.append(this.convert(this.voice_.toString()));
        sb.append(this.convert(this.gender_.toString()));
        sb.append(this.convert(this.case_.toString()));
        sb.append(this.convert(this.degree_.toString()));
        assert (sb.length() == 9);
        return sb.toString();
    }

    public String toHumanString() {
        String morph_string;
        StringBuilder sb = new StringBuilder();
        if (this.pos_ != Pos.Undef) {
            sb.append("pos=");
            sb.append(this.convertHuman(0, this.pos_.toString()));
        }
        if ((morph_string = this.toHumanMorphString()) != "_") {
            sb.append('|');
            sb.append(morph_string);
        }
        return morph_string;
    }

    public static LdtMorphTag parseString(String string) {
        LdtMorphTag tag = new LdtMorphTag();
        block17: for (int index = 0; index < string.length(); ++index) {
            char c = string.charAt(index);
            String c_string = switch (c) {
                case '-' -> "Undef";
                case '1' -> "first";
                case '2' -> "second";
                case '3' -> "third";
                default -> Character.toString(c);
            };
            switch (index) {
                case 0: {
                    tag.pos_ = Pos.valueOf(c_string);
                    continue block17;
                }
                case 1: {
                    tag.person_ = Person.valueOf(c_string);
                    continue block17;
                }
                case 2: {
                    tag.number_ = Number.valueOf(c_string);
                    continue block17;
                }
                case 3: {
                    tag.tense_ = Tense.valueOf(c_string);
                    continue block17;
                }
                case 4: {
                    tag.mood_ = Mood.valueOf(c_string);
                    continue block17;
                }
                case 6: {
                    tag.gender_ = Gender.valueOf(c_string);
                    continue block17;
                }
                case 5: {
                    tag.voice_ = Voice.valueOf(c_string);
                    continue block17;
                }
                case 7: {
                    tag.case_ = Case.valueOf(c_string);
                    continue block17;
                }
                case 8: {
                    tag.degree_ = Degree.valueOf(c_string);
                    continue block17;
                }
                default: {
                    throw new RuntimeException("Unknown value: " + c);
                }
            }
        }
        return tag;
    }

    private String convertHuman(int position, String string) {
        return switch (string) {
            case "first" -> "1";
            case "second" -> "2";
            case "third" -> "3";
            default -> string;
        };
    }

    private char convert(String string) {
        if (string.length() == 1) {
            return string.charAt(0);
        }
        if (string.equalsIgnoreCase("first")) {
            return '1';
        }
        if (string.equalsIgnoreCase("second")) {
            return '2';
        }
        if (string.equalsIgnoreCase("third")) {
            return '3';
        }
        return '-';
    }

    public LdtMorphTag merge(LdtMorphTag other) {
        StringBuilder sb = new StringBuilder(9);
        String this_string = this.toString();
        String other_string = other.toString();
        for (int index = 0; index < this_string.length(); ++index) {
            char this_c = this_string.charAt(index);
            char other_c = other_string.charAt(index);
            if (this_c == '-') {
                sb.append(other_c);
                continue;
            }
            if (other_c == '-') {
                sb.append(this_c);
                continue;
            }
            if (this_c == other_c) {
                sb.append(this_c);
                continue;
            }
            return null;
        }
        return LdtMorphTag.parseString(sb.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdtMorphTag other = (LdtMorphTag)obj;
        return this.toString().equals(other.toString());
    }

    public void reset() {
        this.person_ = Person.Undef;
        this.number_ = Number.Undef;
        this.tense_ = Tense.Undef;
        this.voice_ = Voice.Undef;
        this.mood_ = Mood.Undef;
        this.gender_ = Gender.Undef;
        this.pos_ = Pos.Undef;
        this.case_ = Case.Undef;
        this.degree_ = Degree.Undef;
    }

    @Override
    public String toHumanMorphString() {
        StringBuilder sb = new StringBuilder(9);
        if (this.person_ != Person.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("per");
            sb.append('=');
            sb.append(this.convertHuman(1, this.person_.toString()));
        }
        if (this.number_ != Number.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("num");
            sb.append('=');
            sb.append(this.convertHuman(2, this.number_.toString()));
        }
        if (this.tense_ != Tense.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("ten");
            sb.append('=');
            sb.append(this.convertHuman(3, this.tense_.toString()));
        }
        if (this.mood_ != Mood.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("mood");
            sb.append('=');
            sb.append(this.convertHuman(4, this.mood_.toString()));
        }
        if (this.voice_ != Voice.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("voc");
            sb.append('=');
            sb.append(this.convertHuman(5, this.voice_.toString()));
        }
        if (this.gender_ != Gender.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("gen");
            sb.append('=');
            sb.append(this.convertHuman(6, this.gender_.toString()));
        }
        if (this.case_ != Case.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("cas");
            sb.append('=');
            sb.append(this.convertHuman(7, this.case_.toString()));
        }
        if (this.degree_ != Degree.Undef) {
            if (sb.length() > 0) {
                sb.append('|');
            }
            sb.append("deg");
            sb.append('=');
            sb.append(this.convertHuman(8, this.degree_.toString()));
        }
        if (sb.length() == 0) {
            return "_";
        }
        return sb.toString();
    }

    @Override
    public String toPosString() {
        if (this.pos_ == Pos.Undef) {
            return "_";
        }
        return this.pos_.toString();
    }

    public static enum Pos {
        Undef,
        n,
        v,
        t,
        a,
        d,
        c,
        r,
        p,
        m,
        i,
        e,
        u,
        x;

    }

    public static enum Person {
        Undef,
        first,
        second,
        third;

    }

    public static enum Number {
        Undef,
        s,
        p;

    }

    public static enum Tense {
        Undef,
        p,
        i,
        r,
        l,
        t,
        f;

    }

    public static enum Mood {
        Undef,
        i,
        s,
        n,
        m,
        p,
        d,
        g,
        u;

    }

    public static enum Gender {
        Undef,
        m,
        f,
        n;

    }

    public static enum Case {
        Undef,
        n,
        g,
        d,
        a,
        b,
        v,
        l;

    }

    public static enum Degree {
        Undef,
        c,
        s;

    }

    public static enum Voice {
        Undef,
        a,
        p;

    }
}

