/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.InspectionAdjunct;
import com.saxonica.ee.stream.feed.ExistenceFeed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;

public class CountStreamer
extends InspectionAdjunct
implements FeedMaker {
    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new ExistenceFeed(this.getExpression(), out, context){
            long count;
            {
                this.count = 0L;
            }

            @Override
            public void action() {
                ++this.count;
            }

            @Override
            public void close() throws XPathException {
                this.getNextOutputter().append(Int64Value.makeIntegerValue(this.count));
                this.count = 0L;
                this.getNextOutputter().close();
            }
        };
    }
}

