/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.StringValueGatherer;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class TypedValueFeed
extends AbsorptionFeed {
    private int depth = 0;
    private StringBuilder buffer;

    public TypedValueFeed(ItemFeed result, XPathContext context) {
        super(result, context);
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingTypedValue(sequenceNr, node);
    }

    @Override
    protected Sequence processGroundedItem(Item item) throws XPathException {
        if (item instanceof AtomicValue) {
            return item;
        }
        if (item instanceof NodeInfo) {
            return item.atomize();
        }
        if (item instanceof ArrayItem) {
            return item.atomize();
        }
        this.dynamicError(new XPathException("Cannot atomize item of type " + Type.displayTypeName(item), "FOTY0013"));
        return null;
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.depth == 0) {
            this.buffer = new StringBuilder(256);
        }
        ++this.depth;
    }

    @Override
    public void endDocument() throws XPathException {
        --this.depth;
        if (this.depth == 0) {
            this.append(new StringValue(this.buffer.toString()));
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.depth == 0) {
            this.buffer = new StringBuilder(256);
        }
        ++this.depth;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.startElement(elemName, type, location, properties);
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        if (this.depth == 0) {
            this.characters(namespaceUri.toUnicodeString(), Loc.NONE, properties);
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
        if (this.depth == 0) {
            this.characters(StringView.of(value), location, properties);
        }
    }

    @Override
    public void startContent() {
    }

    @Override
    public void endElement() throws XPathException {
        --this.depth;
        if (this.depth == 0) {
            this.append(new StringValue(this.buffer.toString()));
        }
    }

    @Override
    public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
        if (this.depth == 0) {
            this.append(new StringValue(chars.tidy()));
        } else {
            this.buffer.append(chars);
        }
    }

    @Override
    public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
        if (this.depth == 0) {
            this.characters(data, location, properties);
        }
    }

    @Override
    public void comment(UnicodeString content, Location location, int properties) throws XPathException {
        if (this.depth == 0) {
            this.characters(content, Loc.NONE, properties);
        }
    }

    private static class PendingTypedValue
    extends AbsorptionFeed.PendingItem {
        public UnicodeBuilder buffer = new UnicodeBuilder();
        public FleetingParentNode node;

        public PendingTypedValue(int sequence, FleetingParentNode node) {
            super(sequence);
            this.node = node;
        }

        @Override
        public Receiver getGatherer() {
            return new StringValueGatherer(this.buffer);
        }

        @Override
        public Sequence deliver() throws XPathException {
            this.node.setStringValue(this.buffer.toUnicodeString());
            return this.node.atomize();
        }

        @Override
        public void rollback() {
            this.buffer.clear();
        }
    }
}

