/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.pull.PullEvent;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullTracer
extends PullFilter {
    private NamePool pool;

    public PullTracer(PullProvider base) {
        super(base);
    }

    @Override
    public PullEvent next() throws XPathException {
        this.currentEvent = super.next();
        this.traceEvent(this.currentEvent);
        return this.currentEvent;
    }

    private void traceEvent(PullEvent event) {
        if (this.pool == null) {
            this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
        }
        PullProvider in = this.getUnderlyingProvider();
        switch (event) {
            case START_DOCUMENT: {
                System.err.println("START_DOCUMENT");
                break;
            }
            case START_ELEMENT: {
                System.err.println("START_ELEMENT " + in.getNodeName().getDisplayName());
                break;
            }
            case TEXT: {
                System.err.println("TEXT");
                try {
                    String cs = this.getStringValue().toString();
                    StringBuilder sb = new StringBuilder(cs.length() * 5);
                    sb.append('(');
                    for (int i = 0; i < cs.length(); ++i) {
                        sb.append(cs.charAt(i));
                    }
                    sb.append(')');
                    System.err.println(sb);
                }
                catch (XPathException xPathException) {}
                break;
            }
            case COMMENT: {
                System.err.println("COMMENT");
                break;
            }
            case PROCESSING_INSTRUCTION: {
                System.err.println("PROCESSING_INSTRUCTION");
                break;
            }
            case END_ELEMENT: {
                System.err.println("END_ELEMENT " + (in.getNodeName() == null ? "" : in.getNodeName().getDisplayName()));
                break;
            }
            case END_DOCUMENT: {
                System.err.println("END_DOCUMENT");
                break;
            }
            case END_OF_INPUT: {
                System.err.println("END_OF_INPUT");
                break;
            }
            case ATOMIC_VALUE: {
                try {
                    System.err.println("ATOMIC VALUE: " + in.getStringValue().toString());
                    break;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
        }
    }
}

