/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToStringCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageFromStack;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.om.Item;

public class StringFnCompiler
extends ToStringCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        StringFnCompiler.visitAnnotation(compiler, "StringFn-str");
        LabelInfo stringReturn = methodInfo.newLabel("StringReturn");
        LabelInfo end = methodInfo.newLabel("endTryCatch");
        LabelInfo L0 = methodInfo.newLabel("L0");
        LabelInfo L1 = methodInfo.newLabel("L1");
        LabelInfo L2 = methodInfo.newLabel("L2");
        ga.visitTryCatchBlock(L0, L1, L2, "java/lang/UnsupportedOperationException");
        methodInfo.placeLabel(L0);
        compiler.compileToItem(fnc.getArg(0));
        this.returnZeroLengthStringIfNull(fnc.getArg(0), ga, methodInfo, stringReturn, 0);
        ga.invokeInstanceMethod(Item.class, "getStringValueCS", new Class[0]);
        methodInfo.placeLabel(stringReturn);
        if (requiredClass == String.class) {
            ga.invokeInstanceMethod(Object.class, "toString", new Class[0]);
        }
        methodInfo.placeLabel(L1);
        ga.goTo(end.label());
        methodInfo.placeLabel(L2);
        StringFnCompiler.visitAnnotation(compiler, "CatchStringFn");
        ga.invokeInstanceMethod(UnsupportedOperationException.class, "getMessage", new Class[0]);
        compiler.generateParameterizedDynamicError(MessageFromStack.getInstance(), "FOTY0014", expression.getLocation(), false);
        methodInfo.placeLabel(end);
    }
}

