/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamingPatternMaker;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.MotionlessFeed;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;

public class Inversion {
    private List<PushAction> route = new ArrayList<PushAction>();

    public static Inversion invertExpression(Expression exp, boolean forGrouping) throws XPathException {
        Inversion route = (Inversion)exp.getExtraProperty("inversion");
        if (route != null) {
            return route;
        }
        route = new Inversion();
        if (Streamability.getSweep(exp) == Sweep.CONSUMING) {
            PushAction action = Inversion.makePushAction(exp, forGrouping);
            if (action != null) {
                route.append(action);
                if (action.watchMaker == null) {
                    Inversion.processChildExpressions(exp, action, route, forGrouping);
                }
            }
            List<PushAction> r = route.getRoute();
            if (r.get((int)(r.size() - 1)).pushMethod != 8) {
                XPathException err = new XPathException("No streamable path found in expression " + exp.toShortString(), "SXST0060");
                err.setLocator(exp.getLocation());
                throw err;
            }
        } else if (Streamability.getSweep(exp) == Sweep.MOTIONLESS) {
            if (route.getRoute().isEmpty()) {
                if (Inversion.dependsOnPostDescentAccumulator(exp)) {
                    XPathException err = new XPathException("Call to post-descent accumulator function occurs within a template that does not consume the input", "XTDE3420");
                    err.setLocator(exp.getLocation());
                    throw err;
                }
                PushAction action = new PushAction();
                action.watchMaker = (watchManager, out, context) -> {
                    MotionlessFeed feed = new MotionlessFeed(exp, out, context);
                    return new Trigger(AnchorPattern.getInstance(), feed, context);
                };
                action.pushMethod = 8;
                action.expression = Literal.makeEmptySequence();
                route.append(action);
            }
        } else {
            throw new IllegalStateException();
        }
        exp.setExtraProperty("inversion", route);
        return route;
    }

    private static void processChildExpressions(Expression parent, PushAction parentAction, Inversion route, boolean forGrouping) throws XPathException {
        int i = 0;
        Expression firstStreamingChild = null;
        for (Operand info : parent.operands()) {
            Expression child = info.getChildExpression();
            if (info.hasSameFocus()) {
                PushAction childAction;
                XPathException err;
                Sweep sweep = Streamability.getSweep(child);
                if (sweep == Sweep.CONSUMING) {
                    if (firstStreamingChild != null) {
                        err = new XPathException("Expression " + parent.getExpressionName() + " has more than one subexpression that reads descendants. The first is " + firstStreamingChild + "; the second is " + child, "SXST0060");
                        err.setLocator(parent.getLocation());
                        throw err;
                    }
                    childAction = Inversion.makePushAction(child, forGrouping);
                    route.append(childAction);
                    parentAction.feedMaker = parentAction.adjunct.getFeedMaker(i);
                    parentAction.streamingChildSequence = i;
                    if (childAction.watchMaker == null) {
                        Inversion.processChildExpressions(child, childAction, route, forGrouping);
                    }
                    firstStreamingChild = child;
                } else if (child instanceof ContextItemExpression) {
                    childAction = new PushAction();
                    childAction.expression = child;
                    childAction.pushMethod = 8;
                    childAction.watchMaker = (watchManager, out, context) -> {
                        CopyOfFeed copy = new CopyOfFeed(watchManager, out, context);
                        return new Trigger(AnchorPattern.getInstance(), copy, context);
                    };
                    route.append(childAction);
                    parentAction.feedMaker = parentAction.adjunct.getFeedMaker(i);
                    parentAction.streamingChildSequence = i;
                } else if (sweep == Sweep.MOTIONLESS) {
                    if (firstStreamingChild == null && Inversion.dependsOnPostDescentAccumulator(child)) {
                        err = new XPathException("Call to post-descent accumulator function occurs within an instruction that is not a post-descent instruction", "XTDE3420");
                        err.setLocator(child.getLocation());
                        throw err;
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
            ++i;
        }
    }

    private static boolean dependsOnPostDescentAccumulator(Expression exp) {
        if (exp.isCallOn(AccumulatorFn.AccumulatorAfter.class)) {
            return true;
        }
        for (Operand o : exp.operands()) {
            if (!Inversion.dependsOnPostDescentAccumulator(o.getChildExpression())) continue;
            return true;
        }
        return false;
    }

    private static PushAction makePushAction(Expression exp, boolean forGrouping) throws XPathException {
        Configuration config = exp.getConfiguration();
        Operand consumingChild = Streamability.getConsumingOperand(exp);
        PushAction action = new PushAction();
        action.expression = exp;
        action.adjunct = StreamingAdjunct.makeStreamingAdjunct(config, exp);
        action.watchMaker = action.adjunct.getWatchMaker(forGrouping);
        if (action.watchMaker != null) {
            exp.setEvaluationMethod(8);
            action.pushMethod = 8;
            return action;
        }
        if (consumingChild != null) {
            action.pushMethod = 16;
            exp.setEvaluationMethod(16);
            return action;
        }
        ArrayList<String> failures = new ArrayList<String>();
        Pattern selection = StreamingPatternMaker.makeStreamingPattern(exp, config, failures);
        if (selection != null) {
            if (!forGrouping) {
                config.getLogger().warning("** Warning: implicit copy generated for " + exp.toShortString() + " at line " + exp.getLocation().getLineNumber() + " **");
            }
            boolean matchWholeGroup = exp instanceof CurrentGroupCall && forGrouping;
            action.watchMaker = (watchManager, out, context) -> {
                Trigger trigger = CopyOfFeed.getWatch(out, selection, watchManager, context);
                trigger.setMatchCurrentGroup(matchWholeGroup);
                return trigger;
            };
            action.pushMethod = 8;
            return action;
        }
        throw new XPathException("No watch found for " + exp.toShortString());
    }

    public Inversion copy() {
        Inversion r2 = new Inversion();
        r2.route.addAll(this.route);
        return r2;
    }

    public void append(PushAction action) {
        this.route.add(action);
    }

    public void prepend(PushAction action) {
        this.route.add(0, action);
    }

    public List<PushAction> getRoute() {
        return this.route;
    }

    public Trigger getWatch(WatchManager watchManager, Feed parentFeed, XPathContext context) throws XPathException {
        List<PushAction> route = this.getRoute();
        for (PushAction action : route) {
            int pushMethod = action.pushMethod;
            FeedMaker feedMaker = action.feedMaker;
            Expression exp = action.getExpression();
            if (pushMethod == 16) {
                if (feedMaker == null) {
                    XPathException err = new XPathException("Streaming is not possible for " + exp.getExpressionName() + " expression. (No feedMaker available for item feed)", "SXST0060");
                    err.setLocator(exp.getLocation());
                    throw err;
                }
                parentFeed = feedMaker.makeItemFeed(watchManager, parentFeed, context);
                continue;
            }
            if (pushMethod == 8) {
                WatchMaker watchMaker = action.watchMaker;
                if (watchMaker == null) {
                    XPathException err = new XPathException("Streaming is not possible for " + exp.getExpressionName() + "expression. (Internal error: watch action with no watch maker)", "SXST0060");
                    err.setLocator(exp.getLocation());
                    throw err;
                }
                return watchMaker.makeWatch(watchManager, parentFeed, context);
            }
            throw new IllegalStateException("unknown push method " + pushMethod);
        }
        return new Trigger(new NodeTestPattern(ErrorType.getInstance()), parentFeed, context);
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("streamingRoute");
        for (int i = this.route.size() - 1; i >= 0; --i) {
            PushAction action = this.route.get(i);
            out.startSubsidiaryElement("expression");
            out.emitAttribute("name", action.getExpression() == null ? "*unknown*" : action.getExpression().getExpressionName());
            out.emitAttribute("method", this.getMethodName(action.pushMethod));
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private String getMethodName(int pushMethod) {
        switch (pushMethod) {
            case 8: {
                return "watch";
            }
            case 16: {
                return "itemFeed";
            }
        }
        return "" + pushMethod;
    }

    public static class PushAction {
        public Expression expression;
        public int streamingChildSequence;
        public StreamingAdjunct adjunct;
        public int pushMethod;
        public FeedMaker feedMaker;
        public WatchMaker watchMaker;

        public Expression getExpression() {
            return this.expression;
        }
    }
}

