/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import de.ids_mannheim.korapxmltools.AnnotationWorkerPool;
import de.ids_mannheim.korapxmltools.ColoredFormatter;
import de.ids_mannheim.korapxmltools.KorapXml2Conllu;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import picocli.CommandLine;

@CommandLine.Command(name="KorapXml2Conllu", version={"KorapXml2Conllu 2.0-alpha-01"}, mixinStandardHelpOptions=true, description={"Converts KorAP-XML <https://github.com/KorAP/KorAP-XML-Krill#about-korap-xml> base or morpho zips to CoNLL(-U) format with all information necessary for reconstruction in comment lines."})
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b&\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002|}B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010=\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010>J\u0019\u0010Y\u001a\u00020Z2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\u000fJ'\u0010\\\u001a\b\u0012\u0004\u0012\u00020H0\n2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N0MH\u0002\u00a2\u0006\u0002\u0010]J\u0010\u0010^\u001a\u00020\u000b2\u0006\u0010_\u001a\u00020\u000bH\u0002J\u001b\u0010`\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0002\u0010aJ\u001a\u0010b\u001a\u00020Z2\u0006\u0010c\u001a\u00020\u000b2\b\b\u0002\u0010d\u001a\u00020\u000bH\u0002J \u0010e\u001a\u00020Z2\u0006\u0010f\u001a\u00020\u000b2\u0006\u0010d\u001a\u00020\u000b2\u0006\u0010V\u001a\u00020\u0006H\u0002Jr\u0010g\u001a\u00020\u000b2\u0006\u0010h\u001a\u00020\u00022\u0006\u0010i\u001a\u00020\u000b2\b\b\u0002\u0010j\u001a\u00020\u000b2\b\b\u0002\u0010k\u001a\u00020\u000b2\b\b\u0002\u0010l\u001a\u00020\u000b2\b\b\u0002\u0010m\u001a\u00020\u000b2\b\b\u0002\u0010n\u001a\u00020\u000b2\b\b\u0002\u0010o\u001a\u00020\u000b2\b\b\u0002\u0010p\u001a\u00020\u000b2\b\b\u0002\u0010q\u001a\u00020\u000b2\b\b\u0002\u0010 \u001a\u00020\u0002H\u0002JT\u0010r\u001a\u00020\u000b2\u0018\u0010G\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\n0D2\u0006\u0010f\u001a\u00020\u000b2\u0006\u0010s\u001a\u00020\u00022\u0006\u0010h\u001a\u00020\u00022\u0018\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\n0DH\u0002J\u001b\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\n2\u0006\u0010u\u001a\u00020vH\u0002\u00a2\u0006\u0002\u0010wJ\u001c\u0010x\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N0M2\u0006\u0010y\u001a\u00020vH\u0002J\u001b\u0010z\u001a\b\u0012\u0004\u0012\u00020H0\n2\u0006\u0010u\u001a\u00020vH\u0002\u00a2\u0006\u0002\u0010wJ\u001c\u0010{\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0M2\u0006\u0010u\u001a\u00020vH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR(\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0010\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u0004\u0018\u00010\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001e\u0010\u0019\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001d\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0013\"\u0004\b\u001f\u0010\u0015R\u001e\u0010 \u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\b\"\u0004\b'\u0010\u001cR\u001e\u0010(\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010\u0015R\u001e\u0010+\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\b\"\u0004\b-\u0010\u001cR\u001e\u0010.\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\b\"\u0004\b0\u0010\u001cR$\u00101\u001a\b\u0012\u0004\u0012\u00020\u000b028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001e\u00107\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0013\"\u0004\b9\u0010\u0015R\u001e\u0010:\u001a\u00020\u00028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\"\"\u0004\b<\u0010$R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR#\u0010G\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\n0D\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010FR#\u0010J\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\n0D\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010FR)\u0010L\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020N0M0D\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010FR\u001d\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0D\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010FR#\u0010R\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0D\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010FR)\u0010T\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0M0D\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010FR\u001a\u0010V\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010\b\"\u0004\bX\u0010\u001c\u00a8\u0006~"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXml2Conllu;", "Ljava/util/concurrent/Callable;", "", "<init>", "()V", "COMPATIBILITY_MODE", "", "getCOMPATIBILITY_MODE", "()Z", "zipFileNames", "", "", "getZipFileNames", "()[Ljava/lang/String;", "setZipFileNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "siglePattern", "getSiglePattern", "()Ljava/lang/String;", "setSiglePattern", "(Ljava/lang/String;)V", "extractAttributesRegex", "getExtractAttributesRegex", "setExtractAttributesRegex", "sBoundsFromMorpho", "getSBoundsFromMorpho", "setSBoundsFromMorpho", "(Z)V", "logLevel", "getLogLevel", "setLogLevel", "columns", "getColumns", "()I", "setColumns", "(I)V", "lmTrainingData", "getLmTrainingData", "setLmTrainingData", "tokenSeparator", "getTokenSeparator", "setTokenSeparator", "offsets", "getOffsets", "setOffsets", "comments", "getComments", "setComments", "extractMetadataRegex", "", "getExtractMetadataRegex", "()Ljava/util/List;", "setExtractMetadataRegex", "(Ljava/util/List;)V", "annotateWith", "getAnnotateWith", "setAnnotateWith", "threads", "getThreads", "setThreads", "call", "()Ljava/lang/Integer;", "LOGGER", "Ljava/util/logging/Logger;", "annotationWorkerPool", "Lde/ids_mannheim/korapxmltools/AnnotationWorkerPool;", "texts", "Ljava/util/concurrent/ConcurrentHashMap;", "getTexts", "()Ljava/util/concurrent/ConcurrentHashMap;", "sentences", "Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "getSentences", "tokens", "getTokens", "morpho", "", "Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$MorphoSpan;", "getMorpho", "fnames", "getFnames", "metadata", "getMetadata", "extraFeatures", "getExtraFeatures", "waitForMorpho", "getWaitForMorpho", "setWaitForMorpho", "korapxml2conllu", "", "args", "getTokenSpansFromMorho", "(Ljava/util/Map;)[Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "getFoundryFromZipFileName", "zipFileName", "getFoundryFromZipFileNames", "([Ljava/lang/String;)Ljava/lang/String;", "processZipFile", "zipFilePath", "foundry", "processText", "docId", "printConlluToken", "token_index", "token", "lemma", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "tokenOffsetsInSentence", "sentence_index", "extractSpans", "spans", "Lorg/w3c/dom/NodeList;", "(Lorg/w3c/dom/NodeList;)[Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "extractMorphoSpans", "fsSpans", "extractSentenceSpans", "extractMiscSpans", "Span", "MorphoSpan", "app"})
@SourceDebugExtension(value={"SMAP\nKorapXml2Conllu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KorapXml2Conllu.kt\nde/ids_mannheim/korapxmltools/KorapXml2Conllu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,596:1\n1547#2:597\n1618#2,3:598\n1043#2:601\n37#3,2:602\n13291#4,2:604\n13291#4,2:606\n13291#4,2:608\n*S KotlinDebug\n*F\n+ 1 KorapXml2Conllu.kt\nde/ids_mannheim/korapxmltools/KorapXml2Conllu\n*L\n202#1:597\n202#1:598,3\n205#1:601\n207#1:602,2\n336#1:604,2\n366#1:606,2\n424#1:608,2\n*E\n"})
public final class KorapXml2Conllu
implements Callable<Integer> {
    private final boolean COMPATIBILITY_MODE = System.getenv("COMPATIBILITY_MODE") != null;
    @CommandLine.Parameters(description={"At least one zip file name"}, arity="1..*")
    @Nullable
    private String[] zipFileNames;
    @CommandLine.Option(names={"--sigle-pattern", "-p"}, description={"Extract only documents with sigle matching the pattern (regex)"}, paramLabel="PATTERN")
    @Nullable
    private String siglePattern;
    @CommandLine.Option(names={"--extract-attributes-regex", "-e"}, description={"Extract additional attribute values from structure.xml and writes them as comment line in front of the first covered token.", "Example: -e '(posting/id|div/id)'"}, paramLabel="REGEX")
    @NotNull
    private String extractAttributesRegex = "";
    @CommandLine.Option(names={"--s-bounds-from-morpho"}, description={"Not yet implemented: s bounds from morpho"})
    private boolean sBoundsFromMorpho;
    @CommandLine.Option(names={"--log", "-l"}, description={"Log level: one of SEVERE, WARNING, INFO, FINE, FINER, FINEST. Default: ${DEFAULT-VALUE}])"}, paramLabel="LEVEL")
    @NotNull
    private String logLevel = "WARNING";
    @CommandLine.Option(names={"--columns", "-c"}, description={"Number of columns. 1 means just the token. Default: ${DEFAULT-VALUE}", "Possible values: 1-10"}, paramLabel="NUMBER")
    private int columns = 10;
    @CommandLine.Option(names={"--word2vec", "-w"}, description={"Print text in LM training format: tokens separated by space, sentences separated by newline"})
    private boolean lmTrainingData;
    @CommandLine.Option(names={"--token-separator", "-s"}, description={"Token separator. Default: new-line for CoNLL-U, space for word2vec format."}, paramLabel="STRING", defaultValue="\n")
    @NotNull
    private String tokenSeparator = this.lmTrainingData ? " " : "\n";
    @CommandLine.Option(names={"--offsets"}, description={"Not yet implemented: offsets"})
    private boolean offsets;
    @CommandLine.Option(names={"--comments", "-C"}, description={"Not yet implemented: comments"})
    private boolean comments;
    @CommandLine.Option(names={"--extract-metadata-regex", "-m"}, description={"Extract metadata regexes.\nExample: -m '<textSigle>([^<]+)' -m '<creatDate>([^<]+)'"}, paramLabel="REGEX")
    @NotNull
    private List<String> extractMetadataRegex = new ArrayList();
    @CommandLine.Option(names={"--annotate-with", "-A"}, description={"Pipe output through command"}, paramLabel="COMMAND")
    @NotNull
    private String annotateWith = "";
    @CommandLine.Option(names={"--threads", "-T"}, description={"Maximum number of threads to use. Default: ${DEFAULT-VALUE}"}, paramLabel="THREADS")
    private int threads = Runtime.getRuntime().availableProcessors() / 2;
    @NotNull
    private final Logger LOGGER;
    @Nullable
    private AnnotationWorkerPool annotationWorkerPool;
    @NotNull
    private final ConcurrentHashMap<String, String> texts;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> sentences;
    @NotNull
    private final ConcurrentHashMap<String, Span[]> tokens;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, MorphoSpan>> morpho;
    @NotNull
    private final ConcurrentHashMap<String, String> fnames;
    @NotNull
    private final ConcurrentHashMap<String, String[]> metadata;
    @NotNull
    private final ConcurrentHashMap<String, Map<String, String>> extraFeatures;
    private boolean waitForMorpho;

    public KorapXml2Conllu() {
        Logger logger = Logger.getLogger(KorapXml2Conllu.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.LOGGER = logger;
        this.texts = new ConcurrentHashMap();
        this.sentences = new ConcurrentHashMap();
        this.tokens = new ConcurrentHashMap();
        this.morpho = new ConcurrentHashMap();
        this.fnames = new ConcurrentHashMap();
        this.metadata = new ConcurrentHashMap();
        this.extraFeatures = new ConcurrentHashMap();
    }

    public final boolean getCOMPATIBILITY_MODE() {
        return this.COMPATIBILITY_MODE;
    }

    @Nullable
    public final String[] getZipFileNames() {
        return this.zipFileNames;
    }

    public final void setZipFileNames(@Nullable String[] stringArray) {
        this.zipFileNames = stringArray;
    }

    @Nullable
    public final String getSiglePattern() {
        return this.siglePattern;
    }

    public final void setSiglePattern(@Nullable String string) {
        this.siglePattern = string;
    }

    @NotNull
    public final String getExtractAttributesRegex() {
        return this.extractAttributesRegex;
    }

    public final void setExtractAttributesRegex(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.extractAttributesRegex = string;
    }

    public final boolean getSBoundsFromMorpho() {
        return this.sBoundsFromMorpho;
    }

    public final void setSBoundsFromMorpho(boolean bl) {
        this.sBoundsFromMorpho = bl;
    }

    @NotNull
    public final String getLogLevel() {
        return this.logLevel;
    }

    public final void setLogLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.logLevel = string;
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    public final boolean getLmTrainingData() {
        return this.lmTrainingData;
    }

    public final void setLmTrainingData(boolean bl) {
        this.lmTrainingData = bl;
    }

    @NotNull
    public final String getTokenSeparator() {
        return this.tokenSeparator;
    }

    public final void setTokenSeparator(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.tokenSeparator = string;
    }

    public final boolean getOffsets() {
        return this.offsets;
    }

    public final void setOffsets(boolean bl) {
        this.offsets = bl;
    }

    public final boolean getComments() {
        return this.comments;
    }

    public final void setComments(boolean bl) {
        this.comments = bl;
    }

    @NotNull
    public final List<String> getExtractMetadataRegex() {
        return this.extractMetadataRegex;
    }

    public final void setExtractMetadataRegex(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.extractMetadataRegex = list;
    }

    @NotNull
    public final String getAnnotateWith() {
        return this.annotateWith;
    }

    public final void setAnnotateWith(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.annotateWith = string;
    }

    public final int getThreads() {
        return this.threads;
    }

    public final void setThreads(int n) {
        this.threads = n;
    }

    @Override
    @NotNull
    public Integer call() {
        Logger logger;
        ConsoleHandler handler = new ConsoleHandler();
        LogManager.getLogManager().reset();
        handler.setFormatter(new ColoredFormatter());
        Object object = ArrayIteratorKt.iterator(this.LOGGER.getHandlers());
        while (object.hasNext()) {
            Handler handler2 = object.next();
            this.LOGGER.removeHandler(handler2);
        }
        this.LOGGER.addHandler(handler);
        Logger logger2 = this.LOGGER;
        try {
            logger = logger2;
            object = this.logLevel;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string = ((String)object).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            object = Level.parse(string);
        }
        catch (IllegalArgumentException handler2) {
            logger = logger2;
            this.LOGGER.warning("Invalid log level: " + this.logLevel + ". Defaulting to WARNING.");
            object = Level.WARNING;
        }
        logger.setLevel((Level)object);
        Intrinsics.checkNotNull(this.zipFileNames);
        this.LOGGER.info("Processing zip files: " + ArraysKt.joinToString$default(this.zipFileNames, (CharSequence)", ", null, null, 0, null, null, 62, null));
        Intrinsics.checkNotNull(this.zipFileNames);
        this.korapxml2conllu(this.zipFileNames);
        return 0;
    }

    @NotNull
    public final ConcurrentHashMap<String, String> getTexts() {
        return this.texts;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getSentences() {
        return this.sentences;
    }

    @NotNull
    public final ConcurrentHashMap<String, Span[]> getTokens() {
        return this.tokens;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, MorphoSpan>> getMorpho() {
        return this.morpho;
    }

    @NotNull
    public final ConcurrentHashMap<String, String> getFnames() {
        return this.fnames;
    }

    @NotNull
    public final ConcurrentHashMap<String, String[]> getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final ConcurrentHashMap<String, Map<String, String>> getExtraFeatures() {
        return this.extraFeatures;
    }

    public final boolean getWaitForMorpho() {
        return this.waitForMorpho;
    }

    public final void setWaitForMorpho(boolean bl) {
        this.waitForMorpho = bl;
    }

    public final void korapxml2conllu(@NotNull String[] args2) {
        block4: {
            String string;
            String[] stringArray;
            Regex regex;
            String baseZip;
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter(args2, "args");
            ExecutorService executorService = Executors.newFixedThreadPool(this.threads);
            Intrinsics.checkNotNullExpressionValue(executorService, "newFixedThreadPool(...)");
            ExecutorService executor = executorService;
            if (!Intrinsics.areEqual(this.annotateWith, "")) {
                this.annotationWorkerPool = new AnnotationWorkerPool(this.annotateWith, this.threads, this.LOGGER);
            }
            Ref.ObjectRef<String[]> zips = new Ref.ObjectRef<String[]>();
            zips.element = args2;
            if (args2.length == 1 && new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence = (CharSequence)args2[0]) && new File(baseZip = (regex = new Regex("\\.([^/.]+)\\.zip$")).replace((CharSequence)(stringArray = (String[])args2[0]), string = ".zip")).exists()) {
                stringArray = new String[]{baseZip, ((String[])zips.element)[0]};
                zips.element = stringArray;
                this.LOGGER.info("Processing base zip file: " + baseZip);
            }
            this.waitForMorpho = ((Object[])zips.element).length > 1;
            Arrays.stream((Object[])zips.element).forEach(arg_0 -> KorapXml2Conllu.korapxml2conllu$lambda$0(new Function1<String, Unit>(executor, this, zips){
                final /* synthetic */ ExecutorService $executor;
                final /* synthetic */ KorapXml2Conllu this$0;
                final /* synthetic */ Ref.ObjectRef<String[]> $zips;
                {
                    this.$executor = $executor;
                    this.this$0 = $receiver;
                    this.$zips = $zips;
                    super(1);
                }

                public final void invoke(String zipFilePath) {
                    this.$executor.submit(() -> korapxml2conllu.1.invoke$lambda$0(this.this$0, zipFilePath, this.$zips));
                }

                private static final void invoke$lambda$0(KorapXml2Conllu this$0, String $zipFilePath, Ref.ObjectRef $zips) {
                    Intrinsics.checkNotNullParameter(this$0, "this$0");
                    Intrinsics.checkNotNullParameter($zips, "$zips");
                    String string = $zipFilePath;
                    if (string == null) {
                        string = "";
                    }
                    KorapXml2Conllu.access$processZipFile(this$0, string.toString(), KorapXml2Conllu.access$getFoundryFromZipFileNames(this$0, (String[])$zips.element));
                }
            }, arg_0));
            executor.shutdown();
            while (!executor.isTerminated()) {
            }
            Set set = this.texts.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            CollectionsKt.sorted(set).parallelStream().forEach(arg_0 -> KorapXml2Conllu.korapxml2conllu$lambda$1(new Function1<String, Unit>(this){
                final /* synthetic */ KorapXml2Conllu this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(String docId) {
                    if (!this.this$0.getTokens().containsKey(docId)) {
                        Map map2 = this.this$0.getTokens();
                        Map<String, MorphoSpan> map3 = this.this$0.getMorpho().get(docId);
                        Intrinsics.checkNotNull(map3);
                        map2.put(docId, KorapXml2Conllu.access$getTokenSpansFromMorho(this.this$0, map3));
                    }
                    Intrinsics.checkNotNull(docId);
                    String string = this.this$0.getFnames().get(docId);
                    Intrinsics.checkNotNull(string);
                    KorapXml2Conllu.access$processText(this.this$0, docId, KorapXml2Conllu.access$getFoundryFromZipFileName(this.this$0, string), true);
                }
            }, arg_0));
            if (!(((CharSequence)this.annotateWith).length() > 0)) break block4;
            this.LOGGER.info("closing worker pool");
            AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
            if (annotationWorkerPool != null) {
                annotationWorkerPool.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Span[] getTokenSpansFromMorho(Map<String, MorphoSpan> morpho) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = morpho.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void key;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"-"};
            List fromTo = StringsKt.split$default((CharSequence)key, stringArray, false, 0, 6, null);
            collection.add(new Span(Integer.parseInt((String)fromTo.get(0)), Integer.parseInt((String)fromTo.get(1))));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Span it = (Span)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFrom());
                it = (Span)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getFrom());
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Span[0]);
    }

    private final String getFoundryFromZipFileName(String zipFileName) {
        CharSequence charSequence = zipFileName;
        if (!new Regex(".*\\.([^/.]+)\\.zip$").matches(charSequence)) {
            return "base";
        }
        charSequence = zipFileName;
        Regex regex = new Regex(".*\\.([^/.]+)\\.zip$");
        String string = "$1";
        return regex.replace(charSequence, string);
    }

    private final String getFoundryFromZipFileNames(String[] zipFileNames) {
        for (String zipFileName : zipFileNames) {
            String foundry = this.getFoundryFromZipFileName(zipFileName);
            if (Intrinsics.areEqual(foundry, "base")) continue;
            return foundry;
        }
        return "base";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processZipFile(String zipFilePath, String foundry) {
        try {
            Closeable closeable = new ZipFile(zipFilePath);
            Throwable throwable = null;
            try {
                ZipFile zipFile = (ZipFile)closeable;
                boolean bl = false;
                ((Stream)zipFile.stream().parallel()).forEach(arg_0 -> KorapXml2Conllu.processZipFile$lambda$5$lambda$4(new Function1(zipFile, this, foundry){
                    final /* synthetic */ ZipFile $zipFile;
                    final /* synthetic */ KorapXml2Conllu this$0;
                    final /* synthetic */ String $foundry;
                    {
                        this.$zipFile = $zipFile;
                        this.this$0 = $receiver;
                        this.$foundry = $foundry;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(ZipEntry zipEntry) {
                        block34: {
                            try {
                                String string;
                                String string22;
                                Object inputStream;
                                block36: {
                                    Document document;
                                    String string3 = zipEntry.getName();
                                    Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                                    CharSequence charSequence = string3;
                                    if (!new Regex(".*(data|tokens|structure|morpho)\\.xml$").matches(charSequence)) break block36;
                                    InputStream inputStream2 = this.$zipFile.getInputStream(zipEntry);
                                    Intrinsics.checkNotNullExpressionValue(inputStream2, "getInputStream(...)");
                                    inputStream = inputStream2;
                                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                                    Intrinsics.checkNotNullExpressionValue(documentBuilderFactory, "newInstance(...)");
                                    DocumentBuilderFactory dbFactory = documentBuilderFactory;
                                    DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
                                    Intrinsics.checkNotNullExpressionValue(documentBuilder, "newDocumentBuilder(...)");
                                    DocumentBuilder dBuilder = documentBuilder;
                                    try {
                                        document = dBuilder.parse(new InputSource(new InputStreamReader((InputStream)inputStream, "UTF-8")));
                                    }
                                    catch (SAXParseException e) {
                                        KorapXml2Conllu.access$getLOGGER$p(this.this$0).warning("Error parsing file: " + zipEntry.getName() + " " + e.getMessage());
                                        return;
                                    }
                                    Document document2 = document;
                                    Intrinsics.checkNotNull(document2);
                                    Document doc = document2;
                                    doc.getDocumentElement().normalize();
                                    String string4 = doc.getDocumentElement().getAttribute("docid");
                                    Intrinsics.checkNotNullExpressionValue(string4, "getAttribute(...)");
                                    String docId = string4;
                                    if (this.this$0.getSiglePattern() != null) {
                                        String string5 = this.this$0.getSiglePattern();
                                        Intrinsics.checkNotNull(string5);
                                        if (!new Regex(string5).containsMatchIn(docId)) {
                                            return;
                                        }
                                    }
                                    String string6 = zipEntry.getName();
                                    Intrinsics.checkNotNullExpressionValue(string6, "getName(...)");
                                    CharSequence e = string6;
                                    Regex regex = new Regex(".*?/([^/]+\\.xml)$");
                                    String string7 = "$1";
                                    String fileName = regex.replace(e, string7);
                                    switch (fileName) {
                                        case "data.xml": {
                                            NodeList nodeList = doc.getElementsByTagName("text");
                                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                                            NodeList textsList = nodeList;
                                            if (textsList.getLength() <= 0) break;
                                            ((Map)this.this$0.getTexts()).put(docId, textsList.item(0).getTextContent());
                                            break;
                                        }
                                        case "structure.xml": {
                                            NodeList nodeList = doc.getElementsByTagName("span");
                                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                                            NodeList spans = nodeList;
                                            if (((CharSequence)this.this$0.getExtractAttributesRegex()).length() > 0) {
                                                ((Map)this.this$0.getExtraFeatures()).put(docId, KorapXml2Conllu.access$extractMiscSpans(this.this$0, spans));
                                            }
                                            ((Map)this.this$0.getSentences()).put(docId, KorapXml2Conllu.access$extractSentenceSpans(this.this$0, spans));
                                            break;
                                        }
                                        case "tokens.xml": {
                                            if (!this.this$0.getFnames().contains(docId)) {
                                                ((Map)this.this$0.getFnames()).put(docId, zipEntry.getName());
                                            }
                                            NodeList nodeList = doc.getElementsByTagName("span");
                                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                                            NodeList tokenSpans = nodeList;
                                            ((Map)this.this$0.getTokens()).put(docId, KorapXml2Conllu.access$extractSpans(this.this$0, tokenSpans));
                                            break;
                                        }
                                        case "morpho.xml": {
                                            this.this$0.setWaitForMorpho(true);
                                            ((Map)this.this$0.getFnames()).put(docId, zipEntry.getName());
                                            NodeList nodeList = doc.getElementsByTagName("span");
                                            Intrinsics.checkNotNullExpressionValue(nodeList, "getElementsByTagName(...)");
                                            NodeList fsSpans = nodeList;
                                            ((Map)this.this$0.getMorpho()).put(docId, KorapXml2Conllu.access$extractMorphoSpans(this.this$0, fsSpans));
                                            ((Map)this.this$0.getTokens()).put(docId, KorapXml2Conllu.access$extractSpans(this.this$0, fsSpans));
                                        }
                                    }
                                    if (!(this.this$0.getTexts().get(docId) == null || this.this$0.getSentences().get(docId) == null || this.this$0.getTokens().get(docId) == null || this.this$0.getWaitForMorpho() && this.this$0.getMorpho().get(docId) == null || !this.this$0.getExtractMetadataRegex().isEmpty() && !this.this$0.getMetadata().containsKey(docId))) {
                                        KorapXml2Conllu.access$processText(this.this$0, docId, this.$foundry, this.this$0.getWaitForMorpho());
                                    }
                                    break block34;
                                }
                                if (!(!((Collection)this.this$0.getExtractMetadataRegex()).isEmpty())) break block34;
                                String string8 = zipEntry.getName();
                                Intrinsics.checkNotNullExpressionValue(string8, "getName(...)");
                                inputStream = string8;
                                if (!new Regex(".*/header\\.xml$").matches((CharSequence)inputStream)) break block34;
                                InputStream inputStream3 = this.$zipFile.getInputStream(zipEntry);
                                Intrinsics.checkNotNullExpressionValue(inputStream3, "getInputStream(...)");
                                Closeable dbFactory = inputStream3;
                                Object dBuilder = Charsets.UTF_8;
                                Reader doc = new InputStreamReader((InputStream)dbFactory, (Charset)dBuilder);
                                int docId = 8192;
                                dbFactory = doc instanceof BufferedReader ? (BufferedReader)doc : new BufferedReader(doc, docId);
                                dBuilder = null;
                                try {
                                    Object it = (BufferedReader)dbFactory;
                                    boolean string22 = false;
                                    it = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable it) {
                                    dBuilder = it;
                                    throw it;
                                }
                                finally {
                                    CloseableKt.closeFinally(dbFactory, (Throwable)dBuilder);
                                }
                                Object text = it;
                                dBuilder = Regex.find$default(new Regex("<textSigle>([^<]+)</textSigle>"), (CharSequence)text, 0, 2, null);
                                if (dBuilder != null && (it = dBuilder.getDestructured()) != null && (string22 = ((MatchResult.Destructured)it).getMatch().getGroupValues().get(1)) != null) {
                                    CharSequence fileName = string22;
                                    Regex e = new Regex("/");
                                    String fsSpans = "_";
                                    string = e.replace(fileName, fsSpans);
                                } else {
                                    string = null;
                                }
                                String docId2 = string;
                                KorapXml2Conllu.access$getLOGGER$p(this.this$0).info("Processing header file: " + zipEntry.getName() + " docId: " + docId2);
                                ArrayList<String> meta = new ArrayList<String>();
                                Iterable $this$forEach$iv = this.this$0.getExtractMetadataRegex();
                                boolean $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    String regex = (String)element$iv;
                                    boolean bl = false;
                                    MatchResult match = Regex.find$default(new Regex(regex), (CharSequence)text, 0, 2, null);
                                    if (match == null) continue;
                                    meta.add(match.getDestructured().getMatch().getGroupValues().get(1));
                                }
                                if (!((Collection)meta).isEmpty() && docId2 != null) {
                                    Map map2 = this.this$0.getMetadata();
                                    Collection $this$toTypedArray$iv = meta;
                                    boolean $i$f$toTypedArray = false;
                                    Collection thisCollection$iv = $this$toTypedArray$iv;
                                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                                    map2.put(docId2, stringArray);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ void processZipFile$default(KorapXml2Conllu korapXml2Conllu, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "base";
        }
        korapXml2Conllu.processZipFile(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processText(String docId, String foundry, boolean waitForMorpho) {
        int n;
        StringBuilder output;
        block27: {
            int element$iv2;
            Span[] $this$forEach$iv;
            int previousSpanStart;
            int n2;
            int sentence_index;
            int real_token_index;
            int token_index;
            block28: {
                block25: {
                    Span[] spanArray;
                    block26: {
                        block24: {
                            token_index = 0;
                            real_token_index = 0;
                            sentence_index = 0;
                            output = null;
                            if (!this.lmTrainingData) break block24;
                            output = new StringBuilder();
                            if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                                Object object = this.metadata.get(docId);
                                if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                                    object = "";
                                }
                                output.append((String)object);
                            }
                            Span[] spanArray2 = this.tokens.get(docId);
                            if (spanArray2 == null) break block25;
                            spanArray = spanArray2;
                            boolean $i$f$forEach = false;
                            n2 = spanArray.length;
                            break block26;
                        }
                        output = new StringBuilder("# foundry = " + foundry + "\n# filename = " + this.fnames.get(docId) + "\n# text_id = " + docId + "\n").append(this.tokenOffsetsInSentence(this.sentences, docId, sentence_index, real_token_index, this.tokens));
                        if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                            Object object = this.metadata.get(docId);
                            if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", (CharSequence)"# metadata=", (CharSequence)"\n", 0, null, null, 56, null)) == null) {
                                object = "";
                            }
                            output.append((String)object);
                        }
                        previousSpanStart = 0;
                        Span[] spanArray3 = this.tokens.get(docId);
                        if (spanArray3 == null) break block27;
                        $this$forEach$iv = spanArray3;
                        boolean $i$f$forEach = false;
                        element$iv2 = $this$forEach$iv.length;
                        break block28;
                    }
                    for (n = 0; n < n2; ++real_token_index, ++n) {
                        Span element$iv2;
                        Span span = element$iv2 = spanArray[n];
                        boolean bl = false;
                        ++token_index;
                        int n3 = span.getFrom();
                        Span[] spanArray4 = this.sentences.get(docId);
                        Intrinsics.checkNotNull(spanArray4);
                        if (n3 >= spanArray4[sentence_index].getTo()) {
                            if (((CharSequence)output).length() > 0) {
                                output.setCharAt(output.length() - 1, '\n');
                            } else {
                                output.append("\n");
                            }
                            if (!((Collection)this.extractMetadataRegex).isEmpty()) {
                                Span[] spanArray5 = this.tokens.get(docId);
                                Intrinsics.checkNotNull(spanArray5);
                                if (real_token_index < ((Object[])spanArray5).length - 1) {
                                    Object object = this.metadata.get(docId);
                                    if (object == null || (object = ArraysKt.joinToString$default(object, (CharSequence)"\t", null, (CharSequence)"\t", 0, null, null, 58, null)) == null) {
                                        object = "";
                                    }
                                    output.append((String)object);
                                }
                            }
                            ++sentence_index;
                        }
                        String[] stringArray = new String[2];
                        String string = this.texts.get(docId);
                        Intrinsics.checkNotNull(string);
                        Intrinsics.checkNotNullExpressionValue(string.substring(span.getFrom(), span.getTo()), "substring(...)");
                        stringArray[1] = " ";
                        StringsKt.append(output, stringArray);
                    }
                }
                if (!(((CharSequence)output).length() > 0)) break block27;
                output.deleteCharAt(output.length() - 1);
                break block27;
            }
            for (n2 = 0; n2 < element$iv2; ++real_token_index, ++n2) {
                StringBuilder stringBuilder;
                Span element$iv3;
                Span span = element$iv3 = $this$forEach$iv[n2];
                boolean bl = false;
                ++token_index;
                int n4 = span.getFrom();
                Span[] spanArray = this.sentences.get(docId);
                Intrinsics.checkNotNull(spanArray);
                if (n4 >= spanArray[sentence_index].getTo()) {
                    output.append("\n");
                    token_index = 1;
                    output.append(this.tokenOffsetsInSentence(this.sentences, docId, ++sentence_index, real_token_index, this.tokens));
                }
                if (((CharSequence)this.extractAttributesRegex).length() > 0 && this.extraFeatures.get(docId) != null) {
                    int n5 = span.getFrom() + 1;
                    for (int i = previousSpanStart; i < n5; ++i) {
                        Map<String, String> map2 = this.extraFeatures.get(docId);
                        boolean bl2 = map2 != null ? map2.containsKey(String.valueOf(i)) : false;
                        if (!bl2) continue;
                        Map<String, String> map3 = this.extraFeatures.get(docId);
                        Intrinsics.checkNotNull(map3);
                        output.append(map3.get(String.valueOf(i)));
                        Map<String, String> map4 = this.extraFeatures.get(docId);
                        Intrinsics.checkNotNull(map4);
                        map4.remove(String.valueOf(i));
                    }
                    previousSpanStart = span.getFrom() + 1;
                }
                if (waitForMorpho) {
                    Map<String, MorphoSpan> map5 = this.morpho.get(docId);
                    boolean bl3 = map5 != null ? map5.containsKey(span.getFrom() + "-" + span.getTo()) : false;
                    if (bl3) {
                        Map<String, MorphoSpan> map6 = this.morpho.get(docId);
                        Intrinsics.checkNotNull(map6);
                        MorphoSpan mfs = map6.get(span.getFrom() + "-" + span.getTo());
                        String string = this.texts.get(docId);
                        Intrinsics.checkNotNull(string);
                        String string2 = string.substring(span.getFrom(), span.getTo());
                        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                        MorphoSpan morphoSpan = mfs;
                        Intrinsics.checkNotNull(morphoSpan);
                        String string3 = morphoSpan.getLemma();
                        Intrinsics.checkNotNull(string3);
                        String string4 = mfs.getUpos();
                        Intrinsics.checkNotNull(string4);
                        String string5 = mfs.getXpos();
                        Intrinsics.checkNotNull(string5);
                        String string6 = mfs.getFeats();
                        Intrinsics.checkNotNull(string6);
                        String string7 = mfs.getHead();
                        Intrinsics.checkNotNull(string7);
                        String string8 = mfs.getDeprel();
                        Intrinsics.checkNotNull(string8);
                        String string9 = mfs.getDeps();
                        Intrinsics.checkNotNull(string9);
                        String string10 = mfs.getMisc();
                        Intrinsics.checkNotNull(string10);
                        stringBuilder = output.append(this.printConlluToken(token_index, string2, string3, string4, string5, string6, string7, string8, string9, string10, this.columns));
                        continue;
                    }
                }
                String string = this.texts.get(docId);
                Intrinsics.checkNotNull(string);
                String string11 = string.substring(span.getFrom(), span.getTo());
                Intrinsics.checkNotNullExpressionValue(string11, "substring(...)");
                stringBuilder = output.append(KorapXml2Conllu.printConlluToken$default(this, token_index, string11, null, null, null, null, null, null, null, null, this.columns, 1020, null));
            }
        }
        if (!Intrinsics.areEqual(this.annotateWith, "")) {
            AnnotationWorkerPool annotationWorkerPool = this.annotationWorkerPool;
            if (annotationWorkerPool != null) {
                String string = output.append("\n# eot\n").toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                annotationWorkerPool.pushToQueue(string);
            }
        } else {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                boolean bl = false;
                System.out.println((Object)output.toString());
                Unit unit = Unit.INSTANCE;
            }
        }
        ConcurrentHashMap[] previousSpanStart = new ConcurrentHashMap[]{this.tokens, this.texts, this.sentences, this.morpho, this.fnames, this.metadata, this.extraFeatures};
        ConcurrentHashMap[] $this$forEach$iv = previousSpanStart;
        boolean bl = false;
        int n6 = 0;
        n = $this$forEach$iv.length;
        while (n6 < n) {
            ConcurrentHashMap element$iv;
            ConcurrentHashMap map7 = element$iv = $this$forEach$iv[n6];
            boolean bl4 = false;
            map7.remove(docId);
            ++n6;
        }
        return;
    }

    private final String printConlluToken(int token_index, String token2, String lemma, String upos, String xpos, String feats, String head, String deprel, String deps, String misc, int columns) {
        String myUpos = this.COMPATIBILITY_MODE && Intrinsics.areEqual(upos, "_") ? xpos : upos;
        return switch (columns) {
            case 1 -> token2 + "\n";
            case 10 -> token_index + "\t" + token2 + "\t" + lemma + "\t" + myUpos + "\t" + xpos + "\t" + feats + "\t" + head + "\t" + deprel + "\t" + deps + "\t" + misc + this.tokenSeparator;
            default -> {
                Object[] var13_13 = new Object[]{token_index, token2, lemma, myUpos, xpos, feats, head, deprel, deps, misc};
                yield CollectionsKt.joinToString$default(ArraysKt.slice(var13_13, RangesKt.until(0, Math.min(columns, 10))), "\t", null, this.tokenSeparator, 0, null, null, 58, null);
            }
        };
    }

    static /* synthetic */ String printConlluToken$default(KorapXml2Conllu korapXml2Conllu, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string2 = "_";
        }
        if ((n3 & 8) != 0) {
            string3 = "_";
        }
        if ((n3 & 0x10) != 0) {
            string4 = "_";
        }
        if ((n3 & 0x20) != 0) {
            string5 = "_";
        }
        if ((n3 & 0x40) != 0) {
            string6 = "_";
        }
        if ((n3 & 0x80) != 0) {
            string7 = "_";
        }
        if ((n3 & 0x100) != 0) {
            string8 = "_";
        }
        if ((n3 & 0x200) != 0) {
            string9 = "_";
        }
        if ((n3 & 0x400) != 0) {
            n2 = 10;
        }
        return korapXml2Conllu.printConlluToken(n, string, string2, string3, string4, string5, string6, string7, string8, string9, n2);
    }

    private final String tokenOffsetsInSentence(ConcurrentHashMap<String, Span[]> sentences, String docId, int sentence_index, int token_index, ConcurrentHashMap<String, Span[]> tokens) {
        block4: {
            block3: {
                if (sentences.get(docId) == null) break block3;
                Span[] spanArray = sentences.get(docId);
                Intrinsics.checkNotNull(spanArray);
                if (((Object[])spanArray).length > sentence_index) break block4;
            }
            return "";
        }
        Span[] spanArray = sentences.get(docId);
        Intrinsics.checkNotNull(spanArray);
        int sentenceEndOffset = spanArray[sentence_index].getTo();
        int i = token_index;
        StringBuilder start_offsets_string = new StringBuilder();
        StringBuilder end_offsets_string = new StringBuilder();
        while (tokens.get(docId) != null) {
            Span[] spanArray2 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray2);
            if (i >= ((Object[])spanArray2).length) break;
            Span[] spanArray3 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray3);
            if (spanArray3[i].getTo() > sentenceEndOffset) break;
            Object[] objectArray = new Object[2];
            objectArray[0] = " ";
            Span[] spanArray4 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray4);
            objectArray[1] = spanArray4[i].getFrom();
            StringsKt.append(start_offsets_string, objectArray);
            objectArray = new Object[2];
            objectArray[0] = " ";
            Span[] spanArray5 = tokens.get(docId);
            Intrinsics.checkNotNull(spanArray5);
            objectArray[1] = spanArray5[i].getTo();
            StringsKt.append(end_offsets_string, objectArray);
            ++i;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = new Object[8];
        objectArray[0] = "# start_offsets = ";
        Span[] spanArray6 = tokens.get(docId);
        Intrinsics.checkNotNull(spanArray6);
        objectArray[1] = spanArray6[token_index].getFrom();
        objectArray[2] = start_offsets_string;
        objectArray[3] = "\n";
        objectArray[4] = "# end_offsets = ";
        objectArray[5] = sentenceEndOffset;
        objectArray[6] = end_offsets_string;
        objectArray[7] = "\n";
        String string = StringsKt.append(stringBuilder, objectArray).toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final Span[] extractSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXml2Conllu.extractSpans$lambda$10(extractSpans.2.INSTANCE, arg_0)).map(arg_0 -> KorapXml2Conllu.extractSpans$lambda$11(extractSpans.3.INSTANCE, arg_0)).toArray(KorapXml2Conllu::extractSpans$lambda$12);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, MorphoSpan> extractMorphoSpans(NodeList fsSpans) {
        Regex UNKNOWN = new Regex("(UNKNOWN|<unknown>)");
        Map res = new HashMap();
        IntStream.range(0, fsSpans.getLength()).mapToObj(fsSpans::item).filter(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$13(extractMorphoSpans.2.INSTANCE, arg_0)).forEach(arg_0 -> KorapXml2Conllu.extractMorphoSpans$lambda$14(new Function1<Node, Unit>((Map<String, MorphoSpan>)res, UNKNOWN){
            final /* synthetic */ Map<String, MorphoSpan> $res;
            final /* synthetic */ Regex $UNKNOWN;
            {
                this.$res = $res;
                this.$UNKNOWN = $UNKNOWN;
                super(1);
            }

            public final void invoke(Node node) {
                Intrinsics.checkNotNull(node, "null cannot be cast to non-null type org.w3c.dom.Element");
                NodeList features = ((Element)node).getElementsByTagName("f");
                MorphoSpan fs = new MorphoSpan(null, null, null, null, null, null, null, null, 255, null);
                String fromTo = ((Element)node).getAttribute("from") + "-" + ((Element)node).getAttribute("to");
                IntStream.range(0, features.getLength()).mapToObj(features::item).forEach(arg_0 -> extractMorphoSpans.3.invoke$lambda$0(new Function1<Node, Unit>(fs, this.$UNKNOWN){
                    final /* synthetic */ MorphoSpan $fs;
                    final /* synthetic */ Regex $UNKNOWN;
                    {
                        this.$fs = $fs;
                        this.$UNKNOWN = $UNKNOWN;
                        super(1);
                    }

                    public final void invoke(Node feature) {
                        block29: {
                            Intrinsics.checkNotNull(feature, "null cannot be cast to non-null type org.w3c.dom.Element");
                            String attr = ((Element)feature).getAttribute("name");
                            String string = ((Element)feature).getTextContent();
                            Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
                            String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
                            if (((CharSequence)value).length() == 0) {
                                return;
                            }
                            String string2 = attr;
                            if (string2 == null) break block29;
                            int n = -1;
                            switch (string2.hashCode()) {
                                case 3686108: {
                                    if (string2.equals("xpos")) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case 111188: {
                                    if (string2.equals("pos")) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case 102857384: {
                                    if (string2.equals("lemma")) {
                                        n = 2;
                                    }
                                    break;
                                }
                                case 3596735: {
                                    if (string2.equals("upos")) {
                                        n = 3;
                                    }
                                    break;
                                }
                                case 3063895: {
                                    if (string2.equals("ctag")) {
                                        n = 1;
                                    }
                                    break;
                                }
                                case -1404142937: {
                                    if (string2.equals("certainty")) {
                                        n = 4;
                                    }
                                    break;
                                }
                                case 3575610: {
                                    if (string2.equals("type")) {
                                        n = 5;
                                    }
                                    break;
                                }
                                case 97304961: {
                                    if (string2.equals("feats")) {
                                        n = 6;
                                    }
                                    break;
                                }
                                case 108414: {
                                    if (string2.equals("msd")) {
                                        n = 6;
                                    }
                                    break;
                                }
                            }
                            switch (n) {
                                case 2: {
                                    if (!Intrinsics.areEqual(this.$fs.getLemma(), "_")) break;
                                    CharSequence charSequence = value;
                                    Regex regex = this.$UNKNOWN;
                                    String string3 = "--";
                                    this.$fs.setLemma(regex.replace(charSequence, string3));
                                    break;
                                }
                                case 3: {
                                    this.$fs.setUpos(value);
                                    break;
                                }
                                case 1: {
                                    if (!Intrinsics.areEqual(this.$fs.getXpos(), "_")) break;
                                    CharSequence charSequence = value;
                                    Regex regex = this.$UNKNOWN;
                                    String string4 = "--";
                                    this.$fs.setXpos(regex.replace(charSequence, string4));
                                    break;
                                }
                                case 6: {
                                    if (!Intrinsics.areEqual(this.$fs.getFeats(), "_")) break;
                                    this.$fs.setFeats(value);
                                    break;
                                }
                                case 5: {
                                    if (!Intrinsics.areEqual(this.$fs.getFeats(), "_")) break;
                                    String string5 = ((Element)feature).getElementsByTagName("symbol").item(0).getAttributes().getNamedItem("value").getTextContent();
                                    Intrinsics.checkNotNullExpressionValue(string5, "getTextContent(...)");
                                    this.$fs.setFeats(((Object)StringsKt.trim((CharSequence)string5)).toString());
                                    break;
                                }
                                case 4: {
                                    if (!Intrinsics.areEqual(this.$fs.getMisc(), "_")) break;
                                    this.$fs.setMisc(value);
                                }
                            }
                        }
                    }
                }, arg_0));
                this.$res.put(fromTo, fs);
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        return res;
    }

    private final Span[] extractSentenceSpans(NodeList spans) {
        A[] AArray = IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXml2Conllu.extractSentenceSpans$lambda$15(extractSentenceSpans.2.INSTANCE, arg_0)).map(arg_0 -> KorapXml2Conllu.extractSentenceSpans$lambda$16(extractSentenceSpans.3.INSTANCE, arg_0)).toArray(KorapXml2Conllu::extractSentenceSpans$lambda$17);
        Intrinsics.checkNotNullExpressionValue(AArray, "toArray(...)");
        return (Span[])AArray;
    }

    private final Map<String, String> extractMiscSpans(NodeList spans) {
        Map miscLocal = new HashMap();
        IntStream.range(0, spans.getLength()).mapToObj(spans::item).filter(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$18(extractMiscSpans.2.INSTANCE, arg_0)).forEach(arg_0 -> KorapXml2Conllu.extractMiscSpans$lambda$19(new Function1<Node, Unit>((Map<String, String>)miscLocal, this){
            final /* synthetic */ Map<String, String> $miscLocal;
            final /* synthetic */ KorapXml2Conllu this$0;
            {
                this.$miscLocal = $miscLocal;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Node node) {
                if (node == null) {
                    return;
                }
                String string = ((Element)node).getElementsByTagName("f").item(0).getTextContent();
                Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
                String elementName = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String from = ((Element)node).getAttribute("from");
                Node node2 = ((Element)node).getElementsByTagName("f").item(1);
                Intrinsics.checkNotNull(node2, "null cannot be cast to non-null type org.w3c.dom.Element");
                NodeList attributes = ((Element)node2).getElementsByTagName("f");
                StringBuilder res = new StringBuilder();
                IntStream.range(0, attributes.getLength()).mapToObj(attributes::item).forEach(arg_0 -> extractMiscSpans.3.invoke$lambda$0(new Function1<Node, Unit>(elementName, this.this$0, res){
                    final /* synthetic */ String $elementName;
                    final /* synthetic */ KorapXml2Conllu this$0;
                    final /* synthetic */ StringBuilder $res;
                    {
                        this.$elementName = $elementName;
                        this.this$0 = $receiver;
                        this.$res = $res;
                        super(1);
                    }

                    public final void invoke(Node attr) {
                        Intrinsics.checkNotNull(attr, "null cannot be cast to non-null type org.w3c.dom.Element");
                        String attrName = this.$elementName + "/" + ((Element)attr).getAttribute("name");
                        CharSequence charSequence = attrName;
                        if (new Regex(this.this$0.getExtractAttributesRegex()).matches(charSequence)) {
                            this.$res.append("# " + attrName + " = " + ((Element)attr).getTextContent() + "\n");
                        }
                    }
                }, arg_0));
                if (((CharSequence)res).length() > 0) {
                    if (this.$miscLocal.containsKey(from)) {
                        Map<String, String> map2 = this.$miscLocal;
                        map2.put(from, map2.get(from) + res);
                    } else {
                        this.$miscLocal.put(from, res.toString());
                    }
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        return miscLocal;
    }

    private static final void korapxml2conllu$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void korapxml2conllu$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void processZipFile$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean extractSpans$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Span extractSpans$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Span)$tmp0.invoke(p0);
    }

    private static final Span[] extractSpans$lambda$12(int size) {
        return new Span[size];
    }

    private static final boolean extractMorphoSpans$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void extractMorphoSpans$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean extractSentenceSpans$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Span extractSentenceSpans$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Span)$tmp0.invoke(p0);
    }

    private static final Span[] extractSentenceSpans$lambda$17(int size) {
        return new Span[size];
    }

    private static final boolean extractMiscSpans$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void extractMiscSpans$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$processZipFile(KorapXml2Conllu $this, String zipFilePath, String foundry) {
        $this.processZipFile(zipFilePath, foundry);
    }

    public static final /* synthetic */ String access$getFoundryFromZipFileNames(KorapXml2Conllu $this, String[] zipFileNames) {
        return $this.getFoundryFromZipFileNames(zipFileNames);
    }

    public static final /* synthetic */ Span[] access$getTokenSpansFromMorho(KorapXml2Conllu $this, Map morpho) {
        return $this.getTokenSpansFromMorho(morpho);
    }

    public static final /* synthetic */ void access$processText(KorapXml2Conllu $this, String docId, String foundry, boolean waitForMorpho) {
        $this.processText(docId, foundry, waitForMorpho);
    }

    public static final /* synthetic */ String access$getFoundryFromZipFileName(KorapXml2Conllu $this, String zipFileName) {
        return $this.getFoundryFromZipFileName(zipFileName);
    }

    public static final /* synthetic */ Logger access$getLOGGER$p(KorapXml2Conllu $this) {
        return $this.LOGGER;
    }

    public static final /* synthetic */ Map access$extractMiscSpans(KorapXml2Conllu $this, NodeList spans) {
        return $this.extractMiscSpans(spans);
    }

    public static final /* synthetic */ Span[] access$extractSentenceSpans(KorapXml2Conllu $this, NodeList spans) {
        return $this.extractSentenceSpans(spans);
    }

    public static final /* synthetic */ Span[] access$extractSpans(KorapXml2Conllu $this, NodeList spans) {
        return $this.extractSpans(spans);
    }

    public static final /* synthetic */ Map access$extractMorphoSpans(KorapXml2Conllu $this, NodeList fsSpans) {
        return $this.extractMorphoSpans(fsSpans);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001c\u0018\u00002\u00020\u0001Bg\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$MorphoSpan;", "", "lemma", "", "upos", "xpos", "feats", "head", "deprel", "deps", "misc", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLemma", "()Ljava/lang/String;", "setLemma", "(Ljava/lang/String;)V", "getUpos", "setUpos", "getXpos", "setXpos", "getFeats", "setFeats", "getHead", "setHead", "getDeprel", "setDeprel", "getDeps", "setDeps", "getMisc", "setMisc", "app"})
    public static final class MorphoSpan {
        @Nullable
        private String lemma;
        @Nullable
        private String upos;
        @Nullable
        private String xpos;
        @Nullable
        private String feats;
        @Nullable
        private String head;
        @Nullable
        private String deprel;
        @Nullable
        private String deps;
        @Nullable
        private String misc;

        public MorphoSpan(@Nullable String lemma, @Nullable String upos, @Nullable String xpos, @Nullable String feats, @Nullable String head, @Nullable String deprel, @Nullable String deps, @Nullable String misc) {
            this.lemma = lemma;
            this.upos = upos;
            this.xpos = xpos;
            this.feats = feats;
            this.head = head;
            this.deprel = deprel;
            this.deps = deps;
            this.misc = misc;
        }

        public /* synthetic */ MorphoSpan(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "_";
            }
            if ((n & 2) != 0) {
                string2 = "_";
            }
            if ((n & 4) != 0) {
                string3 = "_";
            }
            if ((n & 8) != 0) {
                string4 = "_";
            }
            if ((n & 0x10) != 0) {
                string5 = "_";
            }
            if ((n & 0x20) != 0) {
                string6 = "_";
            }
            if ((n & 0x40) != 0) {
                string7 = "_";
            }
            if ((n & 0x80) != 0) {
                string8 = "_";
            }
            this(string, string2, string3, string4, string5, string6, string7, string8);
        }

        @Nullable
        public final String getLemma() {
            return this.lemma;
        }

        public final void setLemma(@Nullable String string) {
            this.lemma = string;
        }

        @Nullable
        public final String getUpos() {
            return this.upos;
        }

        public final void setUpos(@Nullable String string) {
            this.upos = string;
        }

        @Nullable
        public final String getXpos() {
            return this.xpos;
        }

        public final void setXpos(@Nullable String string) {
            this.xpos = string;
        }

        @Nullable
        public final String getFeats() {
            return this.feats;
        }

        public final void setFeats(@Nullable String string) {
            this.feats = string;
        }

        @Nullable
        public final String getHead() {
            return this.head;
        }

        public final void setHead(@Nullable String string) {
            this.head = string;
        }

        @Nullable
        public final String getDeprel() {
            return this.deprel;
        }

        public final void setDeprel(@Nullable String string) {
            this.deprel = string;
        }

        @Nullable
        public final String getDeps() {
            return this.deps;
        }

        public final void setDeps(@Nullable String string) {
            this.deps = string;
        }

        @Nullable
        public final String getMisc() {
            return this.misc;
        }

        public final void setMisc(@Nullable String string) {
            this.misc = string;
        }

        public MorphoSpan() {
            this(null, null, null, null, null, null, null, null, 255, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lde/ids_mannheim/korapxmltools/KorapXml2Conllu$Span;", "", "from", "", "to", "<init>", "(II)V", "getFrom", "()I", "setFrom", "(I)V", "getTo", "setTo", "app"})
    public static final class Span {
        private int from;
        private int to;

        public Span(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public final int getFrom() {
            return this.from;
        }

        public final void setFrom(int n) {
            this.from = n;
        }

        public final int getTo() {
            return this.to;
        }

        public final void setTo(int n) {
            this.to = n;
        }
    }
}

