/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ids_mannheim.korap.IndexInfo;
import de.ids_mannheim.korap.KrillIndex;
import de.ids_mannheim.korap.collection.CollectionBuilder;
import de.ids_mannheim.korap.response.Notifications;
import de.ids_mannheim.korap.util.KrillProperties;
import de.ids_mannheim.korap.util.QueryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrillCollection
extends Notifications
implements IndexInfo {
    private KrillIndex index;
    private JsonNode json;
    private final CollectionBuilder cb = new CollectionBuilder(this);
    private CollectionBuilder.Interface cbi;
    private byte[] pl = new byte[4];
    private ObjectMapper mapper = new ObjectMapper();
    private Filter prefiltered = null;
    private static final Logger log = LoggerFactory.getLogger(KrillCollection.class);
    public static final boolean DEBUG = false;
    private double start;
    private double end;

    public KrillCollection() {
    }

    public KrillCollection(KrillIndex index) {
        this.index = index;
    }

    public KrillCollection(String jsonString) {
        try {
            JsonNode json = this.mapper.readTree(jsonString);
            if (json.has("errors") && json.get("errors").size() > 0) {
                this.addError(719, "Json has errors.", new String[0]);
            } else if (json.has("collection")) {
                this.fromKoral(json.get("collection"));
            } else if (json.has("collections")) {
                this.addError(899, "Collections are not supported anymore in favour of a single collection", new String[0]);
            } else {
                this.addError(800, "Collection is not found", new String[0]);
                this.fromBuilder(this.build().nothing());
            }
        }
        catch (QueryException qe) {
            this.addError(qe.getErrorCode(), qe.getMessage(), new String[0]);
            this.fromBuilder(this.build().nothing());
        }
        catch (IOException e) {
            this.addError(621, "Unable to parse JSON", "KrillCollection", e.getLocalizedMessage());
            this.fromBuilder(this.build().nothing());
        }
    }

    public void setIndex(KrillIndex index) {
        this.index = index;
    }

    public KrillCollection fromKoral(String jsonString) throws QueryException {
        this.prefiltered = null;
        try {
            this.fromKoral(this.mapper.readTree(jsonString));
        }
        catch (Exception e) {
            this.addError(621, "Unable to parse JSON", "KrillCollection");
            this.fromBuilder(this.build().nothing());
        }
        return this;
    }

    public KrillCollection fromStore(String ref) throws QueryException {
        String json;
        block26: {
            this.prefiltered = null;
            Object namedVCPath = KrillProperties.namedVCPath;
            if (!((String)namedVCPath).endsWith("/")) {
                namedVCPath = (String)namedVCPath + "/";
            }
            String fileName = (String)namedVCPath + ref + ".jsonld";
            json = null;
            InputStream is = null;
            File file = new File(fileName);
            if (file.exists()) {
                try (FileInputStream fis = new FileInputStream(file);){
                    json = IOUtils.toString((InputStream)fis, "utf-8");
                    break block26;
                }
                catch (IOException e) {
                    this.addError(801, e.getMessage(), new String[0]);
                    return this;
                }
            }
            file = new File(fileName + ".gz");
            if (file.exists()) {
                try (GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(file));
                     ByteArrayOutputStream bos = new ByteArrayOutputStream(512);){
                    bos.write(gzipInputStream);
                    json = bos.toString("utf-8");
                    break block26;
                }
                catch (IOException e) {
                    this.addError(801, e.getMessage(), new String[0]);
                    return this;
                }
            }
            if (KrillProperties.isTest && (is = this.retrieveInputStreamFromClasspath(fileName)) != null) {
                try {
                    json = IOUtils.toString(is, "utf-8");
                }
                catch (IOException e) {
                    this.addError(801, e.getMessage(), new String[0]);
                    return this;
                }
            } else {
                this.addError(800, "Collection is not found " + fileName, new String[0]);
                return this;
            }
        }
        return this.fromKoral(json);
    }

    private InputStream retrieveInputStreamFromClasspath(String fileName) {
        if (!((String)fileName).startsWith("/")) {
            fileName = "/" + (String)fileName;
        }
        return KrillCollection.class.getResourceAsStream((String)fileName);
    }

    public KrillCollection fromKoral(JsonNode json) throws QueryException {
        this.json = json;
        this.prefiltered = null;
        return this.fromBuilder(this._fromKoral(json));
    }

    private CollectionBuilder.Interface _fromKoral(JsonNode json) throws QueryException {
        if (json.has("collection")) {
            return this._fromKoral(json.at("/collection"));
        }
        if (!json.has("@type")) {
            throw new QueryException(701, "JSON-LD group has no @type attribute");
        }
        String type = json.get("@type").asText();
        if (type.equals("koral:doc")) {
            String key = "tokens";
            String valtype = "type:string";
            String match = "match:eq";
            if (json.has("key")) {
                key = json.get("key").asText();
            }
            if (json.has("type")) {
                valtype = json.get("type").asText();
            }
            if (valtype.equals("type:date")) {
                if (!json.has("value")) {
                    throw new QueryException(820, "Dates require value fields");
                }
                String dateStr = json.get("value").asText();
                if (json.has("match")) {
                    match = json.get("match").asText();
                }
                switch (match) {
                    case "match:eq": {
                        return this.cb.date(key, dateStr);
                    }
                    case "match:ne": {
                        return this.cb.date(key, dateStr).not();
                    }
                    case "match:geq": {
                        return this.cb.since(key, dateStr);
                    }
                    case "match:leq": {
                        return this.cb.till(key, dateStr);
                    }
                }
                throw new QueryException(841, "Match relation `" + match + "' unknown for type:date");
            }
            if (valtype.equals("type:integer")) {
                if (!json.has("value")) {
                    throw new QueryException(820, "Integers require value fields");
                }
                int value = json.get("value").asInt();
                if (json.has("match")) {
                    match = json.get("match").asText();
                }
                switch (match) {
                    case "match:geq": {
                        return this.cb.geq(key, value);
                    }
                    case "match:leq": {
                        return this.cb.leq(key, value);
                    }
                    case "match:eq": {
                        return this.cb.eq(key, value);
                    }
                    case "match:ne": {
                        return this.cb.eq(key, value).not();
                    }
                    case "match:gt": {
                        return this.cb.gt(key, value);
                    }
                    case "match:lt": {
                        return this.cb.lt(key, value);
                    }
                }
                throw new QueryException(841, "Match relation `" + match + "' unknown for type:integer");
            }
            if (valtype.equals("type:string")) {
                if (json.get("value").size() > 1) {
                    if (json.has("match")) {
                        match = json.get("match").asText();
                    }
                    CollectionBuilder.Group group = this.cb.orGroup();
                    for (JsonNode value : json.get("value")) {
                        group.with(this.cb.term(key, value.asText()));
                    }
                    if (match.equals("match:ne")) {
                        return group.not();
                    }
                    return group;
                }
                if (json.has("match")) {
                    match = json.get("match").asText();
                }
                switch (match) {
                    case "match:eq": {
                        return this.cb.term(key, json.get("value").asText());
                    }
                    case "match:ne": {
                        return this.cb.term(key, json.get("value").asText()).not();
                    }
                    case "match:contains": {
                        return this.cb.text(key, json.get("value").asText());
                    }
                    case "match:containsnot": {
                        return this.cb.text(key, json.get("value").asText()).not();
                    }
                    case "match:excludes": {
                        return this.cb.text(key, json.get("value").asText()).not();
                    }
                }
                throw new QueryException(841, "Match relation unknown for type");
            }
            if (valtype.equals("type:regex")) {
                if (json.has("match")) {
                    match = json.get("match").asText();
                }
                if (match.equals("match:eq")) {
                    return this.cb.re(key, json.get("value").asText());
                }
                if (match.equals("match:ne")) {
                    return this.cb.re(key, json.get("value").asText()).not();
                }
                if (match.equals("match:contains")) {
                    return this.cb.re(key, json.get("value").asText());
                }
                if (match.equals("match:containsnot")) {
                    return this.cb.re(key, json.get("value").asText());
                }
                if (match.equals("match:excludes")) {
                    return this.cb.re(key, json.get("value").asText()).not();
                }
                throw new QueryException(841, "Match relation unknown for type");
            }
            throw new QueryException(843, "Document type is not supported");
        }
        if (type.equals("koral:docGroup")) {
            CollectionBuilder.Group group;
            if (!json.has("operands") || !json.get("operands").isArray()) {
                throw new QueryException(842, "Document group needs operand list");
            }
            String operation = "operation:and";
            if (json.has("operation")) {
                operation = json.get("operation").asText();
            }
            if (operation.equals("operation:or")) {
                group = this.cb.orGroup();
            } else if (operation.equals("operation:and")) {
                group = this.cb.andGroup();
            } else {
                throw new QueryException(810, "Unknown document group operation");
            }
            for (JsonNode operand : json.get("operands")) {
                group.with(this._fromKoral(operand));
            }
            return group;
        }
        if (type.equals("koral:docGroupRef")) {
            if (!json.has("ref")) {
                throw new QueryException(821, "ref is not found");
            }
            String ref = json.get("ref").asText();
            if (ref.isEmpty()) {
                throw new QueryException(821, "ref is empty");
            }
            return this.cb.referTo(ref);
        }
        throw new QueryException(813, "Collection type is not supported");
    }

    public KrillCollection fromBuilder(CollectionBuilder.Interface cbi) {
        this.prefiltered = null;
        this.cbi = cbi;
        return this;
    }

    public CollectionBuilder.Interface getBuilder() {
        return this.cbi;
    }

    public CollectionBuilder build() {
        return this.cb;
    }

    public KrillCollection filter(CollectionBuilder.Interface filter) {
        return this.fromBuilder(this.cb.andGroup().with(this.cbi).with(filter));
    }

    public KrillCollection extend(CollectionBuilder.Interface extension) {
        return this.fromBuilder(this.cb.orGroup().with(this.cbi).with(extension));
    }

    public KrillCollection filterUIDs(String ... uids) {
        this.prefiltered = null;
        CollectionBuilder.Group cbg = this.cb.orGroup();
        for (String uid : uids) {
            cbg.with(this.cb.term("UID", uid));
        }
        return this.filter(cbg);
    }

    public Filter toFilter() throws QueryException {
        if (this.cbi == null) {
            return null;
        }
        if (this.prefiltered != null) {
            return this.prefiltered;
        }
        this.prefiltered = this.cbi.toFilter();
        return this.prefiltered;
    }

    public boolean isNegative() {
        if (this.cbi == null) {
            return false;
        }
        return this.cbi.isNegative();
    }

    public String toString() {
        try {
            Filter filter = this.toFilter();
            if (filter == null) {
                return "";
            }
            return (this.isNegative() ? "-" : "") + filter.toString();
        }
        catch (QueryException qe) {
            log.warn(qe.getLocalizedMessage());
            return "";
        }
    }

    @Override
    public JsonNode toJsonNode() {
        return this.json;
    }

    public FixedBitSet bits(LeafReaderContext atomic) throws IOException, QueryException {
        LeafReader r = atomic.reader();
        FixedBitSet bitset = new FixedBitSet(r.maxDoc());
        DocIdSet docids = null;
        try {
            docids = this.getDocIdSet(atomic, r.getLiveDocs());
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw new IOException(t);
            }
            if (t instanceof QueryException) {
                throw new QueryException(((QueryException)t).getErrorCode(), t.getLocalizedMessage());
            }
            throw e;
        }
        if (docids == null) {
            if (this.cbi != null) {
                bitset.clear(0, bitset.length());
            } else {
                bitset.set(0, bitset.length());
            }
        } else {
            bitset.or(docids.iterator());
        }
        return bitset;
    }

    public DocIdSet getDocIdSet(LeafReaderContext atomic, Bits acceptDocs) throws IOException, QueryException {
        int maxDoc = atomic.reader().maxDoc();
        FixedBitSet bitset = new FixedBitSet(maxDoc);
        Filter filter = this.toFilter();
        if (filter == null) {
            if (acceptDocs == null) {
                return null;
            }
            bitset.set(0, maxDoc);
        } else {
            DocIdSetIterator filterIter;
            DocIdSet docids = filter.getDocIdSet(atomic, null);
            DocIdSetIterator docIdSetIterator = filterIter = docids == null ? null : docids.iterator();
            if (filterIter == null) {
                if (!this.cbi.isNegative()) {
                    return null;
                }
                bitset.set(0, maxDoc);
            } else {
                bitset.or(filterIter);
                if (this.cbi.isNegative()) {
                    bitset.flip(0, maxDoc);
                }
            }
        }
        return BitsFilteredDocIdSet.wrap(new BitDocIdSet(bitset), acceptDocs);
    }

    public long numberOf(String type) throws IOException {
        return this.numberOf("tokens", type);
    }

    public long numberOf(String field, String type) throws IOException {
        if (this.index == null) {
            return -1L;
        }
        if (this.index.reader() == null) {
            return 0L;
        }
        if (type.equals("documents") || type.equals("base/texts")) {
            if (this.cbi == null) {
                if (this.index.reader() == null) {
                    return 0L;
                }
                return this.index.reader().numDocs();
            }
            return this.docCount();
        }
        Term term = new Term(field, "-:" + type);
        long occurrences = 0L;
        try {
            for (LeafReaderContext atomic : this.index.reader().leaves()) {
                FixedBitSet bits = this.bits(atomic);
                occurrences += this._numberOfAtomic(bits, atomic, term);
            }
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
        }
        catch (QueryException e) {
            log.warn(e.getLocalizedMessage());
        }
        return occurrences;
    }

    private long _numberOfAtomic(Bits docvec, LeafReaderContext atomic, Term term) throws IOException {
        TermsEnum termsEnum;
        Terms terms = atomic.reader().fields().terms(term.field());
        if (terms != null && (termsEnum = terms.iterator(null)).seekExact(term.bytes())) {
            DocsAndPositionsEnum docs = termsEnum.docsAndPositions(docvec, null, 2);
            if (docs.docID() == Integer.MAX_VALUE) {
                return 0L;
            }
            long occurrences = 0L;
            while (docs.nextDoc() != Integer.MAX_VALUE) {
                if (docs.freq() < 1) continue;
                docs.nextPosition();
                BytesRef payload = docs.getPayload();
                if (payload == null) continue;
                System.arraycopy(payload.bytes, payload.offset, this.pl, 0, 4);
                occurrences += (long)ByteBuffer.wrap(this.pl).getInt();
            }
            return occurrences;
        }
        return 0L;
    }

    public long docCount() {
        if (this.index == null) {
            return 0L;
        }
        long docCount = 0L;
        try {
            for (LeafReaderContext atomic : this.index.reader().leaves()) {
                FixedBitSet bitset = this.bits(atomic);
                if (bitset == null) continue;
                docCount += (long)bitset.cardinality();
            }
        }
        catch (IOException e) {
            log.warn(e.getLocalizedMessage());
        }
        catch (QueryException e) {
            log.warn(e.getLocalizedMessage());
        }
        return docCount;
    }

    private static String _bits(Bits bitset) {
        Object str = "";
        for (int i = 0; i < bitset.length(); ++i) {
            str = (String)str + (bitset.get(i) ? "1" : "0");
        }
        return str;
    }

    @Override
    public Set<String> getAllLeafFingerprints() {
        return this.index.getAllLeafFingerprints();
    }
}

