/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.PendingUpdateAction;
import java.util.Set;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SimpleType;

public class ReplaceAttributeAction
extends PendingUpdateAction {
    private final NodeInfo element;
    private final NodeInfo oldAttribute;
    private final AttributeMap newAttributes;
    private final boolean inherit;

    ReplaceAttributeAction(NodeInfo element, NodeInfo oldAttribute, AttributeMap newAttributes, boolean inherit) {
        this.element = element;
        this.oldAttribute = oldAttribute;
        this.newAttributes = newAttributes;
        this.inherit = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inherit;
    }

    @Override
    public void apply(XPathContext context, Set<MutableNodeInfo> affectedRootSet) throws XPathException {
        if (!(this.element instanceof MutableNodeInfo) || !this.element.getTreeInfo().isMutable()) {
            throw new XPathException("Attempting to update a non-updatable element", "SXUP0081");
        }
        affectedRootSet.add((MutableNodeInfo)this.element.getRoot());
        ((MutableNodeInfo)this.element).removeAttribute(this.oldAttribute);
        int len = this.newAttributes.size();
        for (AttributeInfo att : this.newAttributes) {
            NodeName name = att.getNodeName();
            SimpleType typeCode = att.getType();
            String value = att.getValue();
            int properties = att.getProperties();
            if (this.element.getAttributeValue(name.getNamespaceUri(), name.getLocalPart()) != null) {
                throw new XPathException("Attempting to add an attribute that already exists");
            }
            ((MutableNodeInfo)this.element).addAttribute(name, typeCode, value, properties, this.inherit);
        }
        ((MutableNodeInfo)this.element).removeTypeAnnotation();
    }

    @Override
    public NodeInfo getTargetNode() {
        return this.element;
    }

    public NodeInfo getOldAttribute() {
        return this.oldAttribute;
    }

    public AttributeMap getNewAttributes() {
        return this.newAttributes;
    }

    @Override
    public int getApplyPhase() {
        return 3;
    }
}

