<xsl:stylesheet version="3.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:TextClassifier="java:de.ids_mannheim.TextClassifier"
                exclude-result-prefixes="saxon xs TextClassifier">

    <xsl:output method="xml" indent="yes" saxon:line-length="1000"
    doctype-public="-//IDS//DTD IDS-I5 1.0//EN"
    doctype-system="http://corpora.ids-mannheim.de/I5/DTD/i5.dtd"
    />

    <xsl:variable name="domainClassifier" select="TextClassifier:new('models/dereko_domains_s.classifier')"/>

    <xsl:mode streamable="yes" on-no-match="shallow-copy"/>
    <xsl:mode streamable="no" on-no-match="shallow-copy" name="no-Streaming"/>

    <xsl:template match="idsText">
        <xsl:variable name="idsText" as="node()">
            <xsl:copy-of select="."/>
        </xsl:variable>
        <xsl:apply-templates select="$idsText" mode="no-Streaming"/>
    </xsl:template>

    <xsl:template match="textClass" mode="no-Streaming">
        <textClass>
            <xsl:text>&#xa;</xsl:text>
            <xsl:value-of disable-output-escaping="yes"
                select="TextClassifier:insertCatRefs($domainClassifier, 'topic', ../../../text, 0.0001)"/>
            <xsl:apply-templates mode="no-Streaming"/>
        </textClass>
    </xsl:template>

    <xsl:template match="p[not(normalize-space())]" priority="1.0" mode="no-Streaming"/>

    <xsl:template match="div[not(normalize-space())]" priority="1.0" mode="no-Streaming"/>

    <xsl:template match="p[descendant::div|descendant::p and not(ancestor::item)]" priority="0.9" mode="no-Streaming">
        <div type="section">
            <xsl:apply-templates mode="no-Streaming"/>
        </div>
    </xsl:template>

    <xsl:template match="(ref|emph|hi|text())[parent::div]" priority="0.9" mode="no-Streaming">
        <p>
            <xsl:apply-templates mode="no-Streaming"/>
        </p>
    </xsl:template>

    <xsl:template match="head[parent::p]" mode="no-Streaming">
        <hi rend="bold">
            <xsl:value-of select="."/>
        </hi>
    </xsl:template>

    <xsl:template match="hi[parent::div]" mode="no-Streaming">
        <p>
            <xsl:apply-templates mode="no-Streaming"/>
        </p>
    </xsl:template>

    <xsl:template match="div[ancestor::item]" mode="no-Streaming">
        <p>
            <xsl:apply-templates mode="no-Streaming"/>
        </p>
    </xsl:template>

  <xsl:template match="p[normalize-space(.) = '&#160;']" mode="no-Streaming"/>

</xsl:stylesheet>
