/*
 * Decompiled with CFR 0.152.
 */
package lemming.lemma.toutanova;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public interface Aligner
extends Serializable {
    public List<Integer> align(String var1, String var2);

    public static class Pair {
        private String input_segment_;
        private String output_segment_;

        public Pair(String input_segment, String output_segment) {
            this.input_segment_ = input_segment;
            this.output_segment_ = output_segment;
        }

        public String getInputSegment() {
            return this.input_segment_;
        }

        public String getOutputSegment() {
            return this.output_segment_;
        }

        public String toString() {
            return String.format("%s %s", this.input_segment_, this.output_segment_);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Pair)) {
                return false;
            }
            Pair other_pair = (Pair)other;
            return this.input_segment_.equals(other_pair.input_segment_) && this.output_segment_.equals(other_pair.output_segment_);
        }

        public static List<Pair> toPairs(String input, String output, List<Integer> indexes) {
            LinkedList<Pair> pairs = new LinkedList<Pair>();
            int i_start_index = 0;
            int o_start_index = 0;
            Iterator<Integer> iterator2 = indexes.iterator();
            while (iterator2.hasNext()) {
                int i_end_index = i_start_index + iterator2.next();
                int o_end_index = o_start_index + iterator2.next();
                String input_segment = input.substring(i_start_index, i_end_index);
                assert (input_segment.length() > 0);
                String output_segment = output.substring(o_start_index, o_end_index);
                Pair pair = new Pair(input_segment, output_segment);
                pairs.add(pair);
                i_start_index = i_end_index;
                o_start_index = o_end_index;
            }
            return pairs;
        }
    }

    public static class StaticMethods {
        public static List<Integer> mergeEmptyInputSegments(List<Integer> alignment) {
            LinkedList<Integer> new_alignment = new LinkedList<Integer>();
            Iterator<Integer> iter = alignment.iterator();
            int carry_output = 0;
            while (iter.hasNext()) {
                int input = iter.next();
                int output = iter.next();
                if (input == 0) {
                    if (new_alignment.size() > 0) {
                        new_alignment.set(new_alignment.size() - 1, (Integer)new_alignment.get(new_alignment.size() - 1) + output);
                        continue;
                    }
                    carry_output += output;
                    continue;
                }
                if (carry_output > 0) {
                    output += carry_output;
                    carry_output = 0;
                }
                new_alignment.add(input);
                new_alignment.add(output);
            }
            return new_alignment;
        }
    }
}

