/*
 * Decompiled with CFR 0.152.
 */
package experimental.ising;

import experimental.ising.Belief;
import experimental.ising.Factor;
import experimental.ising.Message;
import java.util.ArrayList;
import java.util.List;

public class Variable {
    private int i;
    private String tagName;
    private Belief belief;
    private int size;
    private ArrayList<Factor> neighbors;
    private ArrayList<Integer> messageIds;
    private ArrayList<Message> messages;

    public Variable(int size, int i, String tagName) {
        this.setSize(size);
        this.setBelief(new Belief(size));
        this.setI(i);
        this.setTagName(tagName);
        this.setNeighbors(new ArrayList<Factor>());
        this.setMessageIds(new ArrayList<Integer>());
        this.setMessages(new ArrayList<Message>());
    }

    public void computeBelief() {
        this.belief.toOnes();
        for (int neighborId = 0; neighborId < this.neighbors.size(); ++neighborId) {
            Factor f = this.neighbors.get(neighborId);
            int messageId = this.messageIds.get(neighborId);
            Message m4 = f.getMessages().get(messageId);
            for (int n = 0; n < this.size; ++n) {
                int n2 = n;
                this.belief.measure[n2] = this.belief.measure[n2] * m4.measure[n];
            }
        }
        this.belief.renormalize();
    }

    public void passMessage() {
        this.computeBelief();
        int neighborId = 0;
        for (Message m1 : this.messages) {
            Factor f = this.neighbors.get(neighborId);
            int messageId = this.messageIds.get(neighborId);
            Message m22 = f.messages.get(messageId);
            for (int n = 0; n < this.size; ++n) {
                m1.measure[n] = this.belief.measure[n] / m22.measure[n];
            }
            m1.renormalize();
            ++neighborId;
        }
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    public void setMessageIds(ArrayList<Integer> messageIds) {
        this.messageIds = messageIds;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(ArrayList<Message> messages) {
        this.messages = messages;
    }

    public List<Factor> getNeighbors() {
        return this.neighbors;
    }

    public void setNeighbors(ArrayList<Factor> neighbors) {
        this.neighbors = neighbors;
    }

    public Belief getBelief() {
        return this.belief;
    }

    public void setBelief(Belief belief) {
        this.belief = belief;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

