/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;

public class SimpleComponentReference
extends SchemaStructure
implements ComponentReference {
    private StructuredQName targetComponentName = null;
    private int targetFingerprint = -1;
    private boolean dangling = false;
    protected SchemaComponent target;
    protected int symbolSpace;

    protected SimpleComponentReference() {
    }

    public SimpleComponentReference(int symbolSpace, StructuredQName name, EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.symbolSpace = symbolSpace;
        this.setTargetComponentName(name);
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    public void setTargetComponentName(StructuredQName name) {
        this.targetComponentName = name;
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.targetComponentName;
    }

    public int getTargetFingerprint() {
        if (this.targetFingerprint == -1) {
            this.targetFingerprint = this.getConfiguration().getNamePool().allocateFingerprint(this.targetComponentName.getURI(), this.targetComponentName.getLocalPart());
        }
        return this.targetFingerprint;
    }

    @Override
    public int getSymbolSpace() {
        return this.symbolSpace;
    }

    @Override
    public SchemaComponent getTarget() throws MissingComponentException {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        return this.target;
    }

    public void setTarget(SchemaComponent target) {
        this.target = target;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler) {
        if (!this.dangling) {
            if (this.target == null) {
                this.tryToResolve(compiler.getPreparedSchema());
            }
            if (this.target == null) {
                this.tryToResolve(compiler.getConfiguration().getSuperSchema());
            }
            if (this.target == null) {
                this.dangling = true;
            }
        }
    }

    private void tryToResolve(PreparedSchema schema) {
        switch (this.symbolSpace) {
            case 801: {
                this.target = schema.getElementDecl(this.getTargetComponentName());
                return;
            }
            case 802: {
                this.target = schema.getAttributeDecl(this.getTargetComponentName());
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }
}

