/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.EncodeForUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;

public class LastModified
extends SystemFunction {
    public ZeroOrOne<DateTimeValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        long lastMod;
        URL absoluteURL;
        URI absoluteURI;
        Object item = arguments[0].head();
        if (item == null) {
            return ZeroOrOne.empty();
        }
        String suppliedURI = item.getStringValue();
        try {
            absoluteURI = ResolveURI.makeAbsolute(suppliedURI, this.getStaticBaseUriString());
        }
        catch (URISyntaxException e) {
            XPathException err = new XPathException("Invalid URI passed to saxon:last-modified(). Base='" + this.getStaticBaseUriString() + " Relative='" + suppliedURI, e);
            err.setErrorCode("FODC0005");
            throw err;
        }
        EncodeForUri.checkPercentEncoding(absoluteURI.toString());
        try {
            absoluteURL = absoluteURI.toURL();
        }
        catch (MalformedURLException e) {
            XPathException err = new XPathException("Invalid URL passed to saxon:last-modified(). Base='" + this.getStaticBaseUriString() + " Relative='" + suppliedURI, e);
            err.setErrorCode("FODC0005");
            throw err;
        }
        try {
            URLConnection connection = absoluteURL.openConnection();
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.connect();
            lastMod = connection.getLastModified();
        }
        catch (IOException e) {
            XPathException err = new XPathException("Cannot read from URI supplied to saxon:last-modified(). Base='" + this.getStaticBaseUriString() + " Relative='" + suppliedURI, e);
            err.setErrorCode("FODC0002");
            throw err;
        }
        if (lastMod == 0L) {
            return ZeroOrOne.empty();
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(lastMod);
        return new ZeroOrOne<DateTimeValue>(new DateTimeValue(c, true));
    }
}

