/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import opennlp.tools.ml.naivebayes.Probability;

public abstract class Probabilities<T> {
    protected Map<T, Double> map = new HashMap<T, Double>();
    protected transient boolean isNormalised = false;
    protected Map<T, Double> normalised;
    protected double confidence = 0.0;

    public void set(T t2, double probability) {
        this.isNormalised = false;
        this.map.put(t2, probability);
    }

    public void set(T t2, Probability<T> probability) {
        this.isNormalised = false;
        this.map.put(t2, probability.get());
    }

    public void setIfLarger(T t2, double probability) {
        Double p = this.map.get(t2);
        if (p == null || probability > p) {
            this.isNormalised = false;
            this.map.put(t2, probability);
        }
    }

    public void setLog(T t2, double probability) {
        this.set(t2, StrictMath.exp(probability));
    }

    public void addIn(T t2, double probability, int count2) {
        this.isNormalised = false;
        Double p = this.map.get(t2);
        if (p == null) {
            p = 1.0;
        }
        probability = StrictMath.pow(probability, count2);
        this.map.put(t2, p * probability);
    }

    public Double get(T t2) {
        Double d = this.normalize().get(t2);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public Double getLog(T t2) {
        return StrictMath.log(this.get(t2));
    }

    public Set<T> getKeys() {
        return this.map.keySet();
    }

    public Map<T, Double> getAll() {
        return this.normalize();
    }

    private Map<T, Double> normalize() {
        if (this.isNormalised) {
            return this.normalised;
        }
        Map<T, Double> temp = this.createMapDataStructure();
        double sum = 0.0;
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            Double p = entry.getValue();
            if (p == null) continue;
            sum += p.doubleValue();
        }
        for (Map.Entry<T, Double> entry : temp.entrySet()) {
            T t2 = entry.getKey();
            Double p = entry.getValue();
            if (p == null) continue;
            temp.put(t2, p / sum);
        }
        this.normalised = temp;
        this.isNormalised = true;
        return temp;
    }

    protected Map<T, Double> createMapDataStructure() {
        return new HashMap();
    }

    public T getMax() {
        double max = 0.0;
        T maxT = null;
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            T t2 = entry.getKey();
            Double temp = entry.getValue();
            if (!(temp >= max)) continue;
            max = temp;
            maxT = t2;
        }
        return maxT;
    }

    public double getMaxValue() {
        return this.get(this.getMax());
    }

    public void discardCountsBelow(double i) {
        ArrayList<T> labelsToRemove = new ArrayList<T>();
        for (Map.Entry<T, Double> entry : this.map.entrySet()) {
            T label = entry.getKey();
            Double sum = entry.getValue();
            if (sum == null) {
                sum = 0.0;
            }
            if (!(sum < i)) continue;
            labelsToRemove.add(label);
        }
        for (Map.Entry<Object, Double> label : labelsToRemove) {
            this.map.remove(label);
        }
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public String toString() {
        return this.getAll().toString();
    }
}

