/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.QueryConnectionTester;
import com.mchange.v2.c3p0.UnifiedConnectionTester;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.ConnectionTestPath;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.sql.SqlUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.sql.PooledConnection;

final class ConnectionTesterConnectionTestPath
implements ConnectionTestPath {
    private static final Throwable[] EMPTY_THROWABLE_HOLDER = new Throwable[1];
    private static final MLogger logger = MLog.getLogger(ConnectionTesterConnectionTestPath.class);
    private final ResourcePool rp;
    private final ConnectionTester connectionTester;
    private final GooGooStatementCache scache;
    private final String testQuery;
    private final boolean c3p0PooledConnections;
    private final boolean connectionTesterIsDefault;
    private final ThrowableHolderPool thp = new ThrowableHolderPool();

    ConnectionTesterConnectionTestPath(ResourcePool resourcePool, ConnectionTester connectionTester, GooGooStatementCache gooGooStatementCache, String string, boolean bl) {
        this.rp = resourcePool;
        this.connectionTester = connectionTester;
        this.scache = gooGooStatementCache;
        this.testQuery = string;
        this.c3p0PooledConnections = bl;
        this.connectionTesterIsDefault = connectionTester instanceof DefaultConnectionTester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testPooledConnection(PooledConnection pooledConnection, Connection connection) throws Exception {
        int n;
        Object object;
        Throwable[] throwableArray = EMPTY_THROWABLE_HOLDER;
        Connection connection2 = null;
        Throwable throwable = null;
        try {
            if (this.scache != null) {
                object = this.testQuery == null && this.connectionTesterIsDefault && this.c3p0PooledConnections ? ((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection() : (connection == null ? (connection2 = pooledConnection.getConnection()) : connection);
            } else if (this.c3p0PooledConnections) {
                object = ((AbstractC3P0PooledConnection)pooledConnection).getPhysicalConnection();
            } else {
                Object object2 = object = connection == null ? (connection2 = pooledConnection.getConnection()) : connection;
            }
            if (this.testQuery == null) {
                n = this.connectionTester.activeCheckConnection((Connection)object);
            } else if (this.connectionTester instanceof UnifiedConnectionTester) {
                throwableArray = this.thp.getThrowableHolder();
                n = ((UnifiedConnectionTester)this.connectionTester).activeCheckConnection((Connection)object, this.testQuery, throwableArray);
            } else if (this.connectionTester instanceof QueryConnectionTester) {
                n = ((QueryConnectionTester)this.connectionTester).activeCheckConnection((Connection)object, this.testQuery);
            } else {
                logger.warning("[c3p0] testQuery '" + this.testQuery + "' ignored. Please set a ConnectionTester that implements com.mchange.v2.c3p0.QueryConnectionTester, or use the DefaultConnectionTester, to test with the testQuery.");
                n = this.connectionTester.activeCheckConnection((Connection)object);
            }
        }
        catch (Exception exception) {
            logger.log(MLevel.FINE, "A Connection test failed with an Exception.", exception);
            n = -1;
            throwable = exception;
        }
        finally {
            if (throwable == null) {
                throwable = throwableArray[0];
            } else if (throwableArray[0] != null && logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Internal Connection Test Exception", throwableArray[0]);
            }
            if (throwableArray != EMPTY_THROWABLE_HOLDER) {
                this.thp.returnThrowableHolder(throwableArray);
            }
            ConnectionUtils.attemptClose(connection2);
        }
        switch (n) {
            case 0: {
                break;
            }
            case -8: {
                this.rp.resetPool();
            }
            case -1: {
                object = throwable == null ? new SQLException("Connection is invalid") : SqlUtils.toSQLException("Connection is invalid", throwable);
                throw object;
            }
            default: {
                throw new Error("Bad Connection Tester (" + this.connectionTester + ") returned invalid status (" + n + ").");
            }
        }
    }

    static final class ThrowableHolderPool {
        LinkedList l = new LinkedList();

        ThrowableHolderPool() {
        }

        synchronized Throwable[] getThrowableHolder() {
            if (this.l.size() == 0) {
                return new Throwable[1];
            }
            return (Throwable[])this.l.remove(0);
        }

        synchronized void returnThrowableHolder(Throwable[] throwableArray) {
            throwableArray[0] = null;
            this.l.add(throwableArray);
        }
    }
}

