/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;

public class StringToDoubleCompiler
extends ConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToDoubleConverter-Item");
        if (allowsEmpty) {
            LabelInfo empty = methodInfo.newLabel("returnEmpty");
            LabelInfo end = methodInfo.newLabel("end");
            this.compileToPrimitive(compiler, expression, Double.TYPE, new OnEmpty.UnwindAndJump(empty));
            ga.invokeStaticMethod(DoubleValue.class, "makeDoubleValue", Double.TYPE);
            ga.goTo(end);
            methodInfo.placeLabel(empty);
            ga.pushNull();
            methodInfo.placeLabel(end);
        } else {
            this.compileToPrimitive(compiler, expression, Double.TYPE, OnEmpty.RETURN_NULL);
            ga.invokeStaticMethod(DoubleValue.class, "makeDoubleValue", Double.TYPE);
        }
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToDoubleConverter-Primitive");
        if (allowsEmpty && !(onEmpty instanceof OnEmpty.UnwindAndJump)) {
            throw new IllegalArgumentException();
        }
        StringToDouble stringToDouble = compiler.getConfiguration().getConversionRules().getStringToDoubleConverter();
        compiler.compileToPrimitive(base, CharSequence.class, onEmpty);
        int strVar = ga.newLocal(CharSequence.class);
        ga.storeLocal(strVar);
        LabelInfo L0 = methodInfo.newLabel("L0_castExpr");
        LabelInfo L1 = methodInfo.newLabel("L1_castExpr");
        LabelInfo L2 = methodInfo.newLabel("L2_castExpr");
        LabelInfo done = methodInfo.newLabel("doneCast");
        ga.visitTryCatchBlock(L0, L1, L2, "java/lang/NumberFormatException");
        methodInfo.placeLabel(L0);
        ExpressionCompiler.allocateStatic(compiler, stringToDouble);
        ga.loadLocal(strVar);
        ga.invokeInstanceMethod(StringToDouble.class, "stringToNumber", CharSequence.class);
        methodInfo.placeLabel(L1);
        ga.goTo(done.label());
        methodInfo.placeLabel(L2);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Cannot cast string to double: {$1}", strVar), "FORG0001", cast.getLocation(), false);
        methodInfo.placeLabel(done);
        methodInfo.releaseLocal(strVar);
    }
}

